/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.WoodBlockKind;
import forestry.arboriculture.ForestryWoodType;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.features.ArboricultureTiles;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;

public class BlockForestryHangingSign
extends CeilingHangingSignBlock
implements IWoodTyped {
    private final ForestryWoodType type;

    public BlockForestryHangingSign(ForestryWoodType type) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(1.0f).m_278183_(), type.getWoodType());
        this.type = type;
    }

    @Override
    public WoodBlockKind getBlockKind() {
        return WoodBlockKind.HANGING_SIGN;
    }

    @Override
    public boolean isFireproof() {
        return false;
    }

    @Override
    public ForestryWoodType getWoodType() {
        return this.type;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> actual) {
        return BlockForestryHangingSign.m_152132_(actual, ArboricultureTiles.HANGING_SIGN.tileType(), SignBlockEntity::m_276836_);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new HangingSignBlockEntity(ArboricultureTiles.HANGING_SIGN.tileType(), pos, state);
    }
}

