/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.entities;

import forestry.arboriculture.entities.ForestryBoat;
import forestry.arboriculture.features.ArboricultureEntities;
import forestry.arboriculture.features.ArboricultureItems;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ForestryChestBoat
extends ForestryBoat
implements HasCustomInventoryScreen,
ContainerEntity {
    private static final int CONTAINER_SIZE = 27;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    @Nullable
    private ResourceLocation lootTable;
    private long lootTableSeed;
    private LazyOptional<?> itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this));

    public ForestryChestBoat(EntityType<? extends Boat> type, Level level) {
        super(type, level);
    }

    public ForestryChestBoat(Level level, double x, double y, double z) {
        this(ArboricultureEntities.CHEST_BOAT.entityType(), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    @Override
    public Item m_38369_() {
        return ArboricultureItems.CHEST_BOAT.item(this.getWoodType());
    }

    protected float m_213802_() {
        return 0.15f;
    }

    protected int m_213801_() {
        return 1;
    }

    @Override
    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.m_219943_(pCompound);
    }

    @Override
    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_219934_(pCompound);
    }

    public void m_213560_(DamageSource pDamageSource) {
        super.m_213560_(pDamageSource);
        this.m_219927_(pDamageSource, this.m_9236_(), (Entity)this);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_9236_().f_46443_ && reason.m_146965_()) {
            Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this);
        }
        super.m_142687_(reason);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.m_7310_((Entity)player) && !player.m_36341_()) {
            return super.m_6096_(player, hand);
        }
        InteractionResult interactionresult = this.m_268996_(player);
        if (interactionresult.m_19077_()) {
            this.m_146852_(GameEvent.f_157803_, (Entity)player);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return interactionresult;
    }

    public void m_213583_(Player player) {
        player.m_5893_((MenuProvider)this);
        if (!player.m_9236_().f_46443_) {
            this.m_146852_(GameEvent.f_157803_, (Entity)player);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
    }

    public void m_6211_() {
        this.m_219953_();
    }

    public int m_6643_() {
        return 27;
    }

    public ItemStack m_8020_(int slot) {
        return this.m_219947_(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return this.m_219936_(slot, amount);
    }

    public ItemStack m_8016_(int slot) {
        return this.m_219945_(slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.m_219940_(slot, stack);
    }

    public SlotAccess m_141942_(int slot) {
        return this.m_219951_(slot);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        return this.m_219954_(player);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
        if (this.lootTable != null && player.m_5833_()) {
            return null;
        }
        this.m_219949_(playerInv.f_35978_);
        return ChestMenu.m_39237_((int)windowId, (Inventory)playerInv, (Container)this);
    }

    @Nullable
    public ResourceLocation m_214142_() {
        return this.lootTable;
    }

    public void m_214199_(@Nullable ResourceLocation lootTable) {
        this.lootTable = lootTable;
    }

    public long m_213803_() {
        return this.lootTableSeed;
    }

    public void m_214065_(long lootTableSeed) {
        this.lootTableSeed = lootTableSeed;
    }

    public NonNullList<ItemStack> m_213659_() {
        return this.items;
    }

    public void m_213775_() {
        this.items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && this.m_6084_()) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this));
    }

    public void m_5785_(Player player) {
        this.m_9236_().m_214171_(GameEvent.f_157802_, this.m_20182_(), GameEvent.Context.m_223717_((Entity)player));
    }
}

