/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.arboriculture.worldgen.FeatureTree;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.worldgen.FeatureHelper;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;

public class FeatureKapok
extends FeatureTree {
    public FeatureKapok(ITreeGenData tree) {
        super(tree, 10, 8);
    }

    @Override
    public Set<BlockPos> generateTrunk(LevelAccessor level, RandomSource rand, TreeBlockTypeLog wood, BlockPos startPos) {
        FeatureHelper.generateTreeTrunk(level, rand, wood, startPos, this.height, this.girth, 0, 0.6f, null, 0.0f);
        FeatureHelper.generateSupportStems(wood, level, rand, startPos, this.height, this.girth, 0.8f, 0.4f);
        HashSet<BlockPos> branchCoords = new HashSet<BlockPos>();
        for (int leafSpawn = this.height + 1; leafSpawn > this.height - 4; leafSpawn -= 2) {
            int radius = Math.round((float)(this.girth * (this.height - leafSpawn)) / 1.5f) + 6;
            branchCoords.addAll(FeatureHelper.generateBranches(level, rand, wood, startPos.m_7918_(0, leafSpawn, 0), this.girth, 0.3f, 0.25f, radius, 6, 1.0f));
        }
        return branchCoords;
    }

    @Override
    protected void generateLeaves(LevelAccessor level, RandomSource rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos startPos) {
        int leafSpawn = this.height + 1;
        FeatureHelper.generateCylinderFromTreeStartPos(level, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(level, leaf, startPos.m_7918_(0, leafSpawn--, 0), this.girth, 0.5f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(level, leaf, startPos.m_7918_(0, leafSpawn, 0), this.girth, 1.9f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        for (BlockPos branchEnd : contour.getBranchEnds()) {
            FeatureHelper.generateCylinderFromPos(level, leaf, branchEnd.m_7494_(), 2.0f + (float)this.girth, 2, FeatureHelper.EnumReplaceMode.AIR, contour);
        }
        for (int times = 0; times < this.height / 4; ++times) {
            int h = 10 + rand.m_188503_(Math.max(1, this.height - 10));
            if (rand.m_188499_() && h < this.height / 2) {
                h = this.height / 2 + rand.m_188503_(this.height / 2);
            }
            int x_off = -1 + rand.m_188503_(3);
            int y_off = -1 + rand.m_188503_(3);
            FeatureHelper.generateSphere(level, startPos.m_7918_(x_off, h, y_off), 1 + rand.m_188503_(1), leaf, FeatureHelper.EnumReplaceMode.AIR, contour);
        }
    }
}

