/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import forestry.core.network.NetworkHandler;
import forestry.core.network.packets.PacketTileStream;
import forestry.core.tiles.TileForestry;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.PacketDistributor;

public class TileStreamUpdateTracker {
    private static final Map<LevelChunk, Set<BlockPos>> UPDATES = new WeakHashMap<LevelChunk, Set<BlockPos>>();

    public static void sendVisualUpdate(TileForestry tile) {
        Level level = tile.m_58904_();
        if (level != null && !level.f_46443_) {
            Set<BlockPos> updatesList;
            LevelChunk dimension = level.m_46745_(tile.m_58899_());
            if (!UPDATES.containsKey(dimension)) {
                updatesList = new HashSet<BlockPos>();
                UPDATES.put(dimension, updatesList);
            } else {
                updatesList = UPDATES.get(dimension);
            }
            updatesList.add(tile.m_58899_());
        }
    }

    public static void syncVisualUpdates() {
        for (Map.Entry<LevelChunk, Set<BlockPos>> entry : UPDATES.entrySet()) {
            Set<BlockPos> pendingUpdates = entry.getValue();
            for (BlockPos updatePos : pendingUpdates) {
                LevelChunk chunk = entry.getKey();
                BlockEntity blockEntity = chunk.m_7702_(updatePos);
                if (!(blockEntity instanceof TileForestry)) continue;
                TileForestry blockEntity2 = (TileForestry)blockEntity;
                NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)new PacketTileStream(blockEntity2));
            }
            pendingUpdates.clear();
        }
    }
}

