/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.alleles;

import forestry.api.genetics.alleles.IRegistryAllele;
import forestry.api.genetics.alleles.IRegistryAlleleValue;
import forestry.api.genetics.alleles.IRegistryChromosome;
import forestry.core.genetics.alleles.RegistryChromosome;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class RegistryAllele<V extends IRegistryAlleleValue>
implements IRegistryAllele<V> {
    private final ResourceLocation id;
    private final IRegistryChromosome<V> chromosome;
    @Nullable
    private V value;

    RegistryAllele(ResourceLocation id, IRegistryChromosome<V> chromosome) {
        this.id = id;
        this.chromosome = chromosome;
        ((RegistryChromosome)chromosome).add(id, this);
    }

    @Override
    public ResourceLocation alleleId() {
        return this.id;
    }

    @Override
    public boolean dominant() {
        return this.value().isDominant();
    }

    @Override
    public V value() {
        if (this.value == null) {
            this.value = this.chromosome.get(this.id);
        }
        return this.value;
    }

    @Override
    public IRegistryChromosome<V> chromosome() {
        return this.chromosome;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.id + "]";
    }
}

