/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import forestry.api.core.tooltips.IToolTipProvider;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.gui.widgets.WidgetManager;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;

public abstract class Widget
implements IToolTipProvider {
    protected final WidgetManager manager;
    protected final int xPos;
    protected final int yPos;
    protected int width = 16;
    protected int height = 16;

    public Widget(WidgetManager manager, int xPos, int yPos) {
        this.manager = manager;
        this.xPos = xPos;
        this.yPos = yPos;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getX() {
        return this.xPos;
    }

    public int getY() {
        return this.yPos;
    }

    public abstract void draw(GuiGraphics var1, int var2, int var3);

    public void update(int mouseX, int mouseY) {
    }

    @Override
    @Nullable
    public ToolTip getToolTip(int mouseX, int mouseY) {
        return null;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.xPos && mouseX <= (double)(this.xPos + this.width) && mouseY >= (double)this.yPos && mouseY <= (double)(this.yPos + this.height);
    }

    @Override
    public boolean isHovering(double mouseX, double mouseY) {
        return this.isMouseOver(mouseX, mouseY);
    }

    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
    }

    public boolean handleMouseRelease(double mouseX, double mouseY, int eventType) {
        return false;
    }

    public void handleMouseMove(int mouseX, int mouseY, int mouseButton, long time) {
    }
}

