/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.api.IForestryApi;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.circuits.ICircuitManager;
import forestry.api.core.ItemGroups;
import forestry.core.items.ItemOverlay;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemElectronTube
extends ItemOverlay {
    public ItemElectronTube(ItemOverlay.IOverlayInfo type) {
        super(ItemGroups.tabForestry, type);
    }

    @Override
    public void m_7373_(ItemStack itemstack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        ArrayList<Pair<ICircuitLayout, ICircuit>> circuits = ItemElectronTube.getCircuits(itemstack);
        if (!circuits.isEmpty()) {
            for (Pair<ICircuitLayout, ICircuit> entry : circuits) {
                list.add((Component)((ICircuitLayout)entry.left()).getUsage().m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.UNDERLINE}));
                ((ICircuit)entry.right()).addTooltip(list);
            }
        } else {
            list.add((Component)Component.m_237113_((String)"<").m_7220_((Component)Component.m_237115_((String)"for.gui.noeffect").m_130946_(">").m_130940_(ChatFormatting.GRAY)));
        }
    }

    private static ArrayList<Pair<ICircuitLayout, ICircuit>> getCircuits(ItemStack stack) {
        ArrayList<Pair<ICircuitLayout, ICircuit>> circuits = new ArrayList<Pair<ICircuitLayout, ICircuit>>();
        ICircuitManager manager = IForestryApi.INSTANCE.getCircuitManager();
        for (ICircuitLayout layout : manager.getLayouts()) {
            ICircuit circuit = manager.getCircuit(layout, stack);
            if (circuit == null) continue;
            circuits.add((Pair<ICircuitLayout, ICircuit>)Pair.of((Object)layout, (Object)circuit));
        }
        return circuits;
    }
}

