/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items.definitions;

import forestry.core.items.definitions.EnumContainerType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;

public class FluidHandlerItemForestry
extends FluidHandlerItemStackSimple.Consumable {
    private final EnumContainerType containerType;

    public FluidHandlerItemForestry(ItemStack container, EnumContainerType containerType) {
        super(container, 1000);
        this.containerType = containerType;
    }

    private boolean contentsAllowed(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return false;
        }
        if (this.containerType == EnumContainerType.CAPSULE) {
            return (double)fluid.getFluidType().getTemperature(fluidStack) < 310.15;
        }
        return true;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return this.contentsAllowed(fluid);
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return this.contentsAllowed(fluid);
    }

    protected void setFluid(FluidStack fluid) {
        super.setFluid(fluid);
        this.container.m_41721_(1);
    }
}

