/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import com.google.common.collect.ImmutableSet;
import forestry.Forestry;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockWorldRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class MultiblockRegistry {
    private static final Map<LevelAccessor, MultiblockWorldRegistry> registries = new HashMap<LevelAccessor, MultiblockWorldRegistry>();

    public static void tickStart(LevelAccessor world) {
        if (registries.containsKey(world)) {
            MultiblockWorldRegistry registry = registries.get(world);
            registry.processMultiblockChanges();
            registry.tickStart();
        }
    }

    public static void onChunkLoaded(LevelAccessor world, int chunkX, int chunkZ) {
        if (registries.containsKey(world)) {
            registries.get(world).onChunkLoaded(chunkX, chunkZ);
        }
    }

    public static void onPartAdded(Level world, IMultiblockComponent part) {
        MultiblockWorldRegistry registry = MultiblockRegistry.getOrCreateRegistry(world);
        registry.onPartAdded(part);
    }

    public static void onPartRemovedFromWorld(Level world, IMultiblockComponent part) {
        if (registries.containsKey(world)) {
            registries.get(world).onPartRemovedFromWorld(part);
        }
    }

    public static void onWorldUnloaded(LevelAccessor world) {
        if (registries.containsKey(world)) {
            registries.get(world).onWorldUnloaded();
            registries.remove(world);
        }
    }

    public static void addDirtyController(LevelAccessor world, IMultiblockControllerInternal controller) {
        if (!registries.containsKey(world)) {
            throw new IllegalArgumentException("Adding a dirty controller to a world that has no registered controllers!");
        }
        registries.get(world).addDirtyController(controller);
    }

    public static void addDeadController(LevelAccessor world, IMultiblockControllerInternal controller) {
        if (registries.containsKey(world)) {
            registries.get(world).addDeadController(controller);
        } else {
            Forestry.LOGGER.warn("Controller {} in world {} marked as dead, but that world is not tracked! Controller is being ignored.", (Object)controller.hashCode(), (Object)world);
        }
    }

    public static Set<IMultiblockControllerInternal> getControllersFromWorld(LevelAccessor world) {
        if (registries.containsKey(world)) {
            return registries.get(world).getControllers();
        }
        return ImmutableSet.of();
    }

    private static MultiblockWorldRegistry getOrCreateRegistry(Level world) {
        if (registries.containsKey(world)) {
            return registries.get(world);
        }
        MultiblockWorldRegistry newRegistry = new MultiblockWorldRegistry(world);
        registries.put((LevelAccessor)world, newRegistry);
        return newRegistry;
    }
}

