/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tab;

import forestry.api.apiculture.ForestryBeeSpecies;
import forestry.api.apiculture.genetics.BeeLifeStage;
import forestry.api.apiculture.genetics.IBeeSpeciesType;
import forestry.api.arboriculture.ForestryTreeSpecies;
import forestry.api.arboriculture.IWoodAccess;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.arboriculture.genetics.TreeLifeStage;
import forestry.api.genetics.ForestrySpeciesTypes;
import forestry.api.genetics.ILifeStage;
import forestry.api.lepidopterology.ForestryButterflySpecies;
import forestry.api.lepidopterology.genetics.ButterflyLifeStage;
import forestry.api.lepidopterology.genetics.IButterflySpeciesType;
import forestry.api.modules.ForestryModuleIds;
import forestry.apiculture.blocks.BlockHiveType;
import forestry.apiculture.blocks.NaturalistChestBlockType;
import forestry.apiculture.features.ApicultureBlocks;
import forestry.apiculture.features.ApicultureItems;
import forestry.arboriculture.ForestryWoodType;
import forestry.arboriculture.WoodAccess;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.features.ArboricultureItems;
import forestry.arboriculture.features.CharcoalBlocks;
import forestry.core.blocks.BlockTypeCoreTesr;
import forestry.core.features.CoreBlocks;
import forestry.core.features.CoreItems;
import forestry.core.features.FluidsItems;
import forestry.core.fluids.ForestryFluids;
import forestry.core.items.definitions.EnumContainerType;
import forestry.core.items.definitions.FluidHandlerItemForestry;
import forestry.core.utils.SpeciesUtil;
import forestry.cultivation.blocks.BlockTypePlanter;
import forestry.cultivation.features.CultivationBlocks;
import forestry.energy.features.EnergyBlocks;
import forestry.factory.blocks.BlockTypeFactoryPlain;
import forestry.factory.blocks.BlockTypeFactoryTesr;
import forestry.factory.features.FactoryBlocks;
import forestry.farming.blocks.EnumFarmBlockType;
import forestry.farming.blocks.EnumFarmMaterial;
import forestry.farming.features.FarmingBlocks;
import forestry.mail.blocks.BlockTypeMail;
import forestry.mail.features.MailBlocks;
import forestry.mail.features.MailItems;
import forestry.mail.items.ItemLetter;
import forestry.modules.features.FeatureCreativeTab;
import forestry.modules.features.FeatureItem;
import forestry.modules.features.FeatureProvider;
import forestry.modules.features.IFeatureRegistry;
import forestry.modules.features.ModFeatureRegistry;
import forestry.sorting.features.SortingBlocks;
import forestry.storage.features.BackpackItems;
import forestry.storage.features.CrateItems;
import forestry.worktable.features.WorktableBlocks;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

@FeatureProvider
public class ForestryCreativeTabs {
    private static final IFeatureRegistry REGISTRY = ModFeatureRegistry.get(ForestryModuleIds.CORE);
    public static final FeatureCreativeTab FORESTRY = REGISTRY.creativeTab("forestry", tab -> {
        tab.m_257737_(CoreItems.PORTABLE_ALYZER::stack);
        tab.m_257501_(ForestryCreativeTabs::addForestryItems);
        tab.withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256731_});
        tab.withTabsAfter(new ResourceKey[]{STORAGE.getKey(), APICULTURE.getKey(), ARBORICULTURE.getKey(), LEPIDOPTEROLOGY.getKey()});
    });
    public static final FeatureCreativeTab APICULTURE = REGISTRY.creativeTab("apiculture", tab -> {
        tab.m_257737_(() -> ((IBeeSpeciesType)SpeciesUtil.BEE_TYPE.get()).createStack(ForestryBeeSpecies.FOREST, (ILifeStage)BeeLifeStage.QUEEN));
        tab.m_257501_(ForestryCreativeTabs::addApicultureItems);
        tab.withTabsBefore(new ResourceKey[]{FORESTRY.getKey()});
        tab.withTabsAfter(new ResourceKey[]{ARBORICULTURE.getKey()});
    });
    public static final FeatureCreativeTab ARBORICULTURE = REGISTRY.creativeTab("arboriculture", tab -> {
        tab.m_257737_(() -> ((ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get()).createStack(ForestryTreeSpecies.OAK, (ILifeStage)TreeLifeStage.SAPLING));
        tab.withTabsBefore(new ResourceKey[]{APICULTURE.getKey()});
        tab.withTabsAfter(new ResourceKey[]{LEPIDOPTEROLOGY.getKey()});
        tab.m_257501_(ForestryCreativeTabs::addArboricultureItems);
    });
    public static final FeatureCreativeTab LEPIDOPTEROLOGY = REGISTRY.creativeTab("lepidopterology", tab -> {
        tab.m_257737_(() -> ((IButterflySpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get()).createStack(ForestryButterflySpecies.MONARCH, (ILifeStage)ButterflyLifeStage.BUTTERFLY));
        tab.m_257501_(ForestryCreativeTabs::addLepidopterologyItems);
        tab.withTabsBefore(new ResourceKey[]{ARBORICULTURE.getKey()});
        tab.withTabsAfter(new ResourceKey[]{AGRICULTURE.getKey()});
    });
    public static final FeatureCreativeTab AGRICULTURE = REGISTRY.creativeTab("agriculture", tab -> {
        tab.m_257737_(() -> CultivationBlocks.MANAGED_PLANTER.stack(BlockTypePlanter.ARBORETUM));
        tab.m_257501_(ForestryCreativeTabs::addAgricultureItems);
        tab.withTabsBefore(new ResourceKey[]{LEPIDOPTEROLOGY.getKey()});
        tab.withTabsAfter(new ResourceKey[]{STORAGE.getKey()});
    });
    public static final FeatureCreativeTab STORAGE = REGISTRY.creativeTab("storage", tab -> {
        tab.m_257737_(BackpackItems.MINER_BACKPACK::stack);
        tab.m_257501_(ForestryCreativeTabs::addStorageItems);
        tab.withTabsBefore(new ResourceKey[]{AGRICULTURE.getKey()});
        tab.withTabsAfter(new ResourceKey[]{MAIL.getKey()});
    });
    public static final FeatureCreativeTab MAIL = REGISTRY.creativeTab("mail", tab -> {
        tab.m_257737_(() -> MailBlocks.BASE.stack(BlockTypeMail.MAILBOX));
        tab.m_257501_(ForestryCreativeTabs::addMailItems);
        tab.withTabsBefore(new ResourceKey[]{STORAGE.getKey()});
    });

    private static void addForestryItems(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output items) {
        ForestryCreativeTabs.addGeneticBasics(items);
        items.m_246326_(CoreItems.FORESTERS_MANUAL);
        items.m_246326_(ApicultureItems.SCOOP);
        items.m_246326_(ApicultureItems.SMOKER);
        items.m_246326_(ArboricultureItems.GRAFTER);
        items.m_246326_(ArboricultureItems.GRAFTER_PROVEN);
        items.m_246326_(CoreItems.SPECTACLES);
        items.m_246326_(SortingBlocks.FILTER);
        items.m_246326_(BackpackItems.APIARIST_BACKPACK);
        items.m_246326_(BackpackItems.ARBORIST_BACKPACK);
        items.m_246326_(BackpackItems.LEPIDOPTERIST_BACKPACK);
        CoreBlocks.NATURALIST_CHEST.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        items.m_246326_(CoreItems.WRENCH);
        items.m_246326_(CoreItems.PIPETTE);
        items.m_246326_(CoreItems.SOLDERING_IRON);
        items.m_246326_(WorktableBlocks.WORKTABLE);
        EnergyBlocks.ENGINES.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        FactoryBlocks.TESR.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        items.m_246326_((ItemLike)FactoryBlocks.PLAIN.get(BlockTypeFactoryPlain.FABRICATOR));
        CoreItems.CIRCUITBOARDS.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        CoreItems.ELECTRON_TUBES.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        items.m_246326_(CoreBlocks.APATITE_ORE);
        items.m_246326_(CoreBlocks.DEEPSLATE_APATITE_ORE);
        items.m_246326_(CoreBlocks.TIN_ORE);
        items.m_246326_(CoreBlocks.DEEPSLATE_TIN_ORE);
        items.m_246326_(CoreItems.APATITE);
        items.m_246326_(CoreItems.RAW_TIN);
        items.m_246326_(CoreItems.FERTILIZER_COMPOUND);
        items.m_246326_(CoreItems.INGOT_TIN);
        items.m_246326_(CoreItems.INGOT_BRONZE);
        items.m_246326_(CoreBlocks.RAW_TIN_BLOCK);
        CoreBlocks.RESOURCE_STORAGE.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        items.m_246326_(CharcoalBlocks.CHARCOAL);
        items.m_246326_(CoreItems.GEAR_COPPER);
        items.m_246326_(CoreItems.GEAR_TIN);
        items.m_246326_(CoreItems.GEAR_BRONZE);
        items.m_246326_(CoreItems.STURDY_CASING);
        items.m_246326_(CoreItems.HARDENED_CASING);
        items.m_246326_(CoreItems.IMPREGNATED_CASING);
        items.m_246326_(CoreItems.FLEXIBLE_CASING);
        items.m_246326_(CoreItems.FERTILIZER_COMPOUND);
        items.m_246326_(CoreItems.CARTON);
        items.m_246326_(CoreItems.BRONZE_PICKAXE);
        items.m_246326_(CoreItems.BRONZE_SHOVEL);
        items.m_246326_(CoreItems.KIT_PICKAXE);
        items.m_246326_(CoreItems.KIT_SHOVEL);
        items.m_246326_(CoreItems.GEAR_TIN);
        items.m_246326_(CoreItems.GEAR_COPPER);
        items.m_246326_(CoreItems.GEAR_BRONZE);
        items.m_246326_(CoreItems.SOLDERING_IRON);
        items.m_246326_(CoreItems.SPECTACLES);
        items.m_246326_(CoreItems.ASH);
        items.m_246326_(CoreItems.PEAT);
        items.m_246326_(CoreItems.BITUMINOUS_PEAT);
        items.m_246326_(CoreItems.BEESWAX);
        items.m_246326_(CoreItems.REFRACTORY_WAX);
        CoreItems.CRAFTING_MATERIALS.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
    }

    private static void addApicultureItems(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output items) {
        ForestryCreativeTabs.addGeneticBasics(items);
        items.m_246326_(BackpackItems.APIARIST_BACKPACK);
        items.m_246326_((ItemLike)CoreBlocks.NATURALIST_CHEST.get(NaturalistChestBlockType.APIARIST_CHEST));
        items.m_246326_(ApicultureItems.SCOOP);
        items.m_246326_(CoreItems.SPECTACLES);
        items.m_246326_(ApicultureItems.APIARIST_HELMET);
        items.m_246326_(ApicultureItems.APIARIST_CHEST);
        items.m_246326_(ApicultureItems.APIARIST_LEGS);
        items.m_246326_(ApicultureItems.APIARIST_BOOTS);
        ApicultureBlocks.BASE.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        for (BlockHiveType type : BlockHiveType.values()) {
            if (type == BlockHiveType.SWARM) continue;
            items.m_246326_((ItemLike)ApicultureBlocks.BEEHIVE.get(type));
        }
        ApicultureBlocks.ALVEARY.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        items.m_246326_(ApicultureItems.FRAME_UNTREATED);
        items.m_246326_(ApicultureItems.FRAME_IMPREGNATED);
        items.m_246326_(ApicultureItems.FRAME_PROVEN);
        ItemStack creativeFrameMaxMutation = ApicultureItems.FRAME_CREATIVE.stack();
        creativeFrameMaxMutation.m_41700_("force_mutations", (Tag)ByteTag.m_128266_((byte)1));
        items.m_246326_(ApicultureItems.FRAME_CREATIVE);
        items.m_246342_(creativeFrameMaxMutation);
        items.m_246326_(ApicultureItems.HONEYED_SLICE);
        items.m_246326_(ApicultureItems.AMBROSIA);
        ApicultureItems.BEE_COMBS.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        ApicultureBlocks.BEE_COMB.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        ApicultureItems.PROPOLIS.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        ApicultureItems.POLLEN_CLUSTER.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        items.m_246326_(ApicultureItems.ROYAL_JELLY);
        items.m_246326_(ApicultureItems.EXPERIENCE_DROP);
        SpeciesUtil.addTypeToCreativeTab(items, ForestrySpeciesTypes.BEE);
    }

    private static void addArboricultureItems(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output items) {
        ForestryCreativeTabs.addGeneticBasics(items);
        items.m_246326_(BackpackItems.ARBORIST_BACKPACK);
        items.m_246326_((ItemLike)CoreBlocks.NATURALIST_CHEST.get(NaturalistChestBlockType.ARBORIST_CHEST));
        items.m_246326_(CoreItems.SPECTACLES);
        items.m_246326_(ArboricultureItems.GRAFTER);
        items.m_246326_(ArboricultureItems.GRAFTER_PROVEN);
        CoreItems.FRUITS.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        items.m_246326_(CharcoalBlocks.LOG_PILE);
        items.m_246326_(CharcoalBlocks.DECORATIVE_LOG_PILE);
        items.m_246326_(CoreItems.ASH);
        WoodAccess access = WoodAccess.INSTANCE;
        for (IWoodType type : access.getRegisteredWoodTypes()) {
            ForestryCreativeTabs.addAllWoodBlocks(items, access, type, false);
        }
        for (IWoodType type : access.getRegisteredWoodTypes()) {
            ForestryCreativeTabs.addAllWoodBlocks(items, access, type, true);
        }
        for (ForestryWoodType type : ForestryWoodType.VALUES) {
            items.m_246326_((ItemLike)ArboricultureItems.BOAT.item(type));
            items.m_246326_((ItemLike)ArboricultureItems.CHEST_BOAT.item(type));
            items.m_246326_((ItemLike)ArboricultureBlocks.SIGN.get(type));
            items.m_246326_((ItemLike)ArboricultureBlocks.HANGING_SIGN.get(type));
        }
        SpeciesUtil.addTypeToCreativeTab(items, ForestrySpeciesTypes.TREE);
        ArboricultureBlocks.LEAVES_DECORATIVE.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
    }

    private static void addLepidopterologyItems(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output items) {
        ForestryCreativeTabs.addGeneticBasics(items);
        items.m_246326_(BackpackItems.LEPIDOPTERIST_BACKPACK);
        items.m_246326_((ItemLike)CoreBlocks.NATURALIST_CHEST.get(NaturalistChestBlockType.LEPIDOPTERIST_CHEST));
        items.m_246326_(ApicultureItems.SCOOP);
        SpeciesUtil.addTypeToCreativeTab(items, ForestrySpeciesTypes.BUTTERFLY);
    }

    private static void addAgricultureItems(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output items) {
        items.m_246326_(CoreItems.WRENCH);
        items.m_246326_(CoreItems.PIPETTE);
        items.m_246326_(CoreItems.SOLDERING_IRON);
        CoreItems.CIRCUITBOARDS.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        CoreItems.ELECTRON_TUBES.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        EnergyBlocks.ENGINES.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        items.m_246326_((ItemLike)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.CARPENTER));
        items.m_246326_((ItemLike)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.CENTRIFUGE));
        items.m_246326_((ItemLike)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.FERMENTER));
        items.m_246326_((ItemLike)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.MOISTENER));
        items.m_246326_((ItemLike)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.SQUEEZER));
        items.m_246326_((ItemLike)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.STILL));
        items.m_246326_((ItemLike)FactoryBlocks.PLAIN.get(BlockTypeFactoryPlain.RAINTANK));
        items.m_246326_((ItemLike)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.RAINMAKER));
        items.m_246326_(CoreItems.IODINE_CHARGE);
        items.m_246326_(CoreItems.DISSIPATION_CHARGE);
        items.m_246326_(CoreItems.PEAT);
        items.m_246326_(CoreItems.BITUMINOUS_PEAT);
        items.m_246326_(CoreBlocks.HUMUS);
        items.m_246326_(CoreBlocks.BOG_EARTH);
        items.m_246326_(CoreItems.COMPOST);
        items.m_246326_(CoreItems.MOULDY_WHEAT);
        items.m_246326_(CoreItems.DECAYING_WHEAT);
        items.m_246326_(CoreItems.MULCH);
        for (EnumFarmMaterial enumFarmMaterial : EnumFarmMaterial.values()) {
            for (EnumFarmBlockType type : EnumFarmBlockType.values()) {
                items.m_246342_(FarmingBlocks.FARM.stack(type, enumFarmMaterial));
            }
        }
        for (Enum enum_ : BlockTypePlanter.values()) {
            items.m_246342_(CultivationBlocks.MANAGED_PLANTER.stack((BlockTypePlanter)enum_));
            items.m_246342_(CultivationBlocks.MANUAL_PLANTER.stack((BlockTypePlanter)enum_));
        }
    }

    private static void addStorageItems(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output items) {
        items.m_246326_(BackpackItems.APIARIST_BACKPACK);
        items.m_246326_(BackpackItems.ARBORIST_BACKPACK);
        items.m_246326_(BackpackItems.LEPIDOPTERIST_BACKPACK);
        items.m_246326_(BackpackItems.MINER_BACKPACK);
        items.m_246326_(BackpackItems.DIGGER_BACKPACK);
        items.m_246326_(BackpackItems.FORESTER_BACKPACK);
        items.m_246326_(BackpackItems.HUNTER_BACKPACK);
        items.m_246326_(BackpackItems.ADVENTURER_BACKPACK);
        items.m_246326_(BackpackItems.BUILDER_BACKPACK);
        items.m_246326_(BackpackItems.MINER_BACKPACK_T_2);
        items.m_246326_(BackpackItems.DIGGER_BACKPACK_T_2);
        items.m_246326_(BackpackItems.FORESTER_BACKPACK_T_2);
        items.m_246326_(BackpackItems.HUNTER_BACKPACK_T_2);
        items.m_246326_(BackpackItems.ADVENTURER_BACKPACK_T_2);
        items.m_246326_(BackpackItems.BUILDER_BACKPACK_T_2);
        items.m_246326_((ItemLike)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.BOTTLER));
        items.m_246326_((ItemLike)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.CARPENTER));
        items.m_246326_(CoreItems.PIPETTE);
        items.m_246326_((ItemLike)CoreBlocks.NATURALIST_CHEST.get(NaturalistChestBlockType.APIARIST_CHEST));
        items.m_246326_((ItemLike)CoreBlocks.NATURALIST_CHEST.get(NaturalistChestBlockType.ARBORIST_CHEST));
        items.m_246326_((ItemLike)CoreBlocks.NATURALIST_CHEST.get(NaturalistChestBlockType.LEPIDOPTERIST_CHEST));
        items.m_246326_(SortingBlocks.FILTER);
        items.m_246326_(CoreItems.CARTON);
        FluidsItems.CONTAINERS.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        items.m_246326_(CrateItems.CRATE);
        items.m_246326_(CoreItems.KIT_PICKAXE);
        items.m_246326_(CoreItems.KIT_SHOVEL);
        for (EnumContainerType enumContainerType : EnumContainerType.values()) {
            for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
                ItemStack itemStack;
                FluidHandlerItemForestry fluidHandler;
                FlowingFluid flowing;
                if (fluid instanceof FlowingFluid && (flowing = (FlowingFluid)fluid).m_5613_() != fluid || (fluidHandler = new FluidHandlerItemForestry(itemStack = FluidsItems.CONTAINERS.stack(enumContainerType), enumContainerType)).fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE) != 1000) continue;
                ItemStack filled = fluidHandler.getContainer();
                items.m_246342_(filled);
            }
        }
        for (Enum enum_ : ForestryFluids.values()) {
            items.m_246326_((ItemLike)((ForestryFluids)enum_).getBucket());
        }
        for (FeatureItem featureItem : CrateItems.getCrates()) {
            items.m_246326_((ItemLike)featureItem);
        }
    }

    private static void addMailItems(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output items) {
        MailBlocks.BASE.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        items.m_246326_(MailItems.CATALOGUE);
        MailItems.STAMPS.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        items.m_246326_((ItemLike)MailItems.LETTERS.get(ItemLetter.Size.EMPTY, ItemLetter.State.FRESH));
    }

    private static void addAllWoodBlocks(CreativeModeTab.Output items, IWoodAccess access, IWoodType type, boolean fireproof) {
        items.m_246342_(access.getStack(type, WoodBlockKind.LOG, fireproof));
        items.m_246342_(access.getStack(type, WoodBlockKind.WOOD, fireproof));
        items.m_246342_(access.getStack(type, WoodBlockKind.STRIPPED_LOG, fireproof));
        items.m_246342_(access.getStack(type, WoodBlockKind.STRIPPED_WOOD, fireproof));
        items.m_246342_(access.getStack(type, WoodBlockKind.PLANKS, fireproof));
        items.m_246342_(access.getStack(type, WoodBlockKind.STAIRS, fireproof));
        items.m_246342_(access.getStack(type, WoodBlockKind.SLAB, fireproof));
        items.m_246342_(access.getStack(type, WoodBlockKind.FENCE, fireproof));
        items.m_246342_(access.getStack(type, WoodBlockKind.FENCE_GATE, fireproof));
        items.m_246342_(access.getStack(type, WoodBlockKind.DOOR, fireproof));
        items.m_246342_(access.getStack(type, WoodBlockKind.TRAPDOOR, fireproof));
        items.m_246342_(access.getStack(type, WoodBlockKind.PRESSURE_PLATE, fireproof));
        items.m_246342_(access.getStack(type, WoodBlockKind.BUTTON, fireproof));
    }

    private static void addGeneticBasics(CreativeModeTab.Output items) {
        items.m_246326_(CoreItems.PORTABLE_ALYZER);
        items.m_246326_(ApicultureItems.HONEY_DROP);
        items.m_246326_(ApicultureItems.HONEYDEW);
        items.m_246326_((ItemLike)CoreBlocks.BASE.get(BlockTypeCoreTesr.ESCRITOIRE));
        items.m_246326_((ItemLike)CoreBlocks.BASE.get(BlockTypeCoreTesr.ANALYZER));
    }
}

