/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.core.ForestryError;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.core.features.CoreTiles;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.FluidTagFilter;
import forestry.core.fluids.TankManager;
import forestry.core.gui.ContainerAnalyzer;
import forestry.core.inventory.InventoryAnalyzer;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.packets.PacketItemStackDisplay;
import forestry.core.tiles.IItemStackDisplay;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.SpeciesUtil;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileAnalyzer
extends TilePowered
implements WorldlyContainer,
ILiquidTankTile,
IItemStackDisplay {
    private static final int TIME_TO_ANALYZE = 125;
    private static final int HONEY_REQUIRED = 100;
    public static int analyzerEnergyPerWork = 20320;
    private final FilteredTank resourceTank;
    private final TankManager tankManager;
    private final Container invInput;
    private final Container invOutput;
    @Nullable
    private IIndividual specimenToAnalyze;
    private ItemStack individualOnDisplayClient = ItemStack.f_41583_;

    public TileAnalyzer(BlockPos pos, BlockState state) {
        super(CoreTiles.ANALYZER.tileType(), pos, state, 800, 40000);
        this.setInternalInventory(new InventoryAnalyzer(this));
        this.resourceTank = new FilteredTank(10000).setFilter(FluidTagFilter.HONEY);
        this.tankManager = new TankManager(this, this.resourceTank);
        this.invInput = new InventoryMapper((Container)this.getInternalInventory(), 2, 6);
        this.invOutput = new InventoryMapper((Container)this.getInternalInventory(), 8, 4);
    }

    @Override
    public void m_183515_(CompoundTag compoundNBT) {
        super.m_183515_(compoundNBT);
        this.tankManager.write(compoundNBT);
    }

    @Override
    public void m_142466_(CompoundTag compoundNBT) {
        super.m_142466_(compoundNBT);
        this.tankManager.read(compoundNBT);
        ItemStack stackToAnalyze = this.m_8020_(0);
        if (!stackToAnalyze.m_41619_()) {
            this.specimenToAnalyze = IIndividualHandlerItem.getIndividual(stackToAnalyze);
        }
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (Container)this, 1);
        }
    }

    @Override
    public boolean workCycle() {
        boolean added;
        ItemStack stackToAnalyze = this.m_8020_(0);
        if (stackToAnalyze.m_41619_() || this.specimenToAnalyze == null) {
            return false;
        }
        if (!this.specimenToAnalyze.isAnalyzed()) {
            FluidStack drained = this.resourceTank.drain(100, IFluidHandler.FluidAction.SIMULATE);
            if (drained.isEmpty() || drained.getAmount() != 100) {
                return false;
            }
            this.resourceTank.drain(100, IFluidHandler.FluidAction.EXECUTE);
            this.specimenToAnalyze.analyze();
            this.specimenToAnalyze.saveToStack(stackToAnalyze);
        }
        if (!(added = InventoryUtil.tryAddStack(this.invOutput, stackToAnalyze, true))) {
            return false;
        }
        this.m_6836_(0, ItemStack.f_41583_);
        PacketItemStackDisplay packet = new PacketItemStackDisplay(this, this.getIndividualOnDisplay());
        NetworkUtil.sendNetworkPacket(packet, this.f_58858_, this.f_58857_);
        return true;
    }

    @Nullable
    private Integer getInputSlotIndex() {
        for (int slotIndex = 0; slotIndex < this.invInput.m_6643_(); ++slotIndex) {
            ItemStack stack = this.invInput.m_8020_(slotIndex);
            if (!IIndividualHandlerItem.isIndividual(stack)) continue;
            return slotIndex;
        }
        return null;
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        super.writeData(data);
        ItemStack displayStack = this.getIndividualOnDisplay();
        data.m_130055_(displayStack);
        this.tankManager.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(FriendlyByteBuf data) {
        super.readData(data);
        this.individualOnDisplayClient = data.m_130267_();
        this.tankManager.readData(data);
    }

    @Override
    public void handleItemStackForDisplay(ItemStack itemStack) {
        if (!ItemStack.m_41728_((ItemStack)itemStack, (ItemStack)this.individualOnDisplayClient)) {
            this.individualOnDisplayClient = itemStack;
            BlockPos pos = this.m_58899_();
            Minecraft.m_91087_().f_91060_.m_109770_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
    }

    @Override
    public boolean hasWork() {
        this.moveSpecimenToAnalyzeSlot();
        ItemStack specimen = this.m_8020_(0);
        boolean hasSpecimen = !specimen.m_41619_();
        boolean hasResource = true;
        boolean hasSpace = true;
        if (hasSpecimen) {
            hasSpace = InventoryUtil.tryAddStack(this.invOutput, specimen, true, false);
            if (this.specimenToAnalyze != null && !this.specimenToAnalyze.isAnalyzed()) {
                FluidStack drained = this.resourceTank.drain(100, IFluidHandler.FluidAction.SIMULATE);
                hasResource = !drained.isEmpty() && drained.getAmount() == 100;
            }
        }
        this.getErrorLogic().setCondition(!hasSpecimen, ForestryError.NO_SPECIMEN);
        this.getErrorLogic().setCondition(!hasResource, ForestryError.NO_RESOURCE_LIQUID);
        this.getErrorLogic().setCondition(!hasSpace, ForestryError.NO_SPACE_INVENTORY);
        return hasSpecimen && hasResource && hasSpace;
    }

    private void moveSpecimenToAnalyzeSlot() {
        if (!this.m_8020_(0).m_41619_()) {
            return;
        }
        Integer slotIndex = this.getInputSlotIndex();
        if (slotIndex == null) {
            return;
        }
        ItemStack inputStack = this.invInput.m_8020_(slotIndex.intValue());
        if (inputStack.m_41619_()) {
            return;
        }
        if (!((ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get()).isMember(inputStack)) {
            inputStack = GeneticsUtil.convertToGeneticEquivalent(inputStack);
        }
        this.specimenToAnalyze = IIndividualHandlerItem.getIndividual(inputStack);
        if (this.specimenToAnalyze == null) {
            return;
        }
        this.m_6836_(0, inputStack);
        this.invInput.m_6836_(slotIndex.intValue(), ItemStack.f_41583_);
        if (this.specimenToAnalyze.isAnalyzed()) {
            this.setTicksPerWorkCycle(1);
            this.setEnergyPerWorkCycle(0);
        } else {
            this.setTicksPerWorkCycle(125);
            this.setEnergyPerWorkCycle(analyzerEnergyPerWork);
        }
        PacketItemStackDisplay packet = new PacketItemStackDisplay(this, this.getIndividualOnDisplay());
        NetworkUtil.sendNetworkPacket(packet, this.f_58858_, this.f_58857_);
    }

    public ItemStack getIndividualOnDisplay() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return this.individualOnDisplayClient;
        }
        return this.m_8020_(0);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(() -> this.tankManager).cast();
        }
        return super.getCapability(capability, facing);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ContainerAnalyzer(windowId, player.m_150109_(), this);
    }
}

