/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TileUtil {
    public static boolean isUsableByPlayer(Player player, BlockEntity tile) {
        BlockPos pos = tile.m_58899_();
        Level world = tile.m_58904_();
        return !tile.m_58901_() && TileUtil.getTile((BlockGetter)world, pos) == tile && player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0;
    }

    @Nullable
    public static BlockEntity getTile(BlockGetter level, BlockPos pos) {
        return level.getExistingBlockEntity(pos);
    }

    @Nullable
    public static <T> T getTile(BlockGetter world, BlockPos pos, Class<T> tileClass) {
        BlockEntity tileEntity = TileUtil.getTile(world, pos);
        if (tileClass.isInstance(tileEntity)) {
            return tileClass.cast(tileEntity);
        }
        return null;
    }

    @Nullable
    public static <T> T getTile(BlockEntity tileEntity, Class<T> tileClass) {
        if (tileClass.isInstance(tileEntity)) {
            return tileClass.cast(tileEntity);
        }
        return null;
    }

    public static <T> void actOnTile(LevelReader world, BlockPos pos, Class<T> tileClass, Consumer<T> tileAction) {
        T tile = TileUtil.getTile((BlockGetter)world, pos, tileClass);
        if (tile != null) {
            tileAction.accept(tile);
        }
    }

    @Nullable
    public static IItemHandler getInventoryFromTile(@Nullable BlockEntity tile, @Nullable Direction side) {
        if (tile == null) {
            return null;
        }
        LazyOptional itemCap = tile.getCapability(ForgeCapabilities.ITEM_HANDLER, side);
        if (itemCap.isPresent()) {
            return (IItemHandler)itemCap.orElse(null);
        }
        if (tile instanceof WorldlyContainer) {
            WorldlyContainer worldly = (WorldlyContainer)tile;
            return new SidedInvWrapper(worldly, side);
        }
        if (tile instanceof Container) {
            Container container = (Container)tile;
            return new InvWrapper(container);
        }
        return null;
    }

    public static <T> LazyOptional<T> getInterface(Level world, BlockPos pos, Capability<T> capability, @Nullable Direction facing) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity == null) {
            return LazyOptional.empty();
        }
        return tileEntity.getCapability(capability, facing);
    }
}

