/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import forestry.api.IForestryApi;
import forestry.api.apiculture.hives.IHive;
import forestry.api.climate.IClimateManager;
import forestry.api.core.HumidityType;
import forestry.api.core.TemperatureType;
import forestry.core.config.ForestryConfig;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public record ForestryBiomeModifier(Holder<PlacedFeature> hive, Holder<PlacedFeature> tree, Holder<PlacedFeature> apatiteOre, Holder<PlacedFeature> tinOre) implements BiomeModifier
{
    public static final Codec<ForestryBiomeModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PlacedFeature.f_191773_.fieldOf("hive").forGetter(ForestryBiomeModifier::hive), (App)PlacedFeature.f_191773_.fieldOf("tree").forGetter(ForestryBiomeModifier::tree), (App)PlacedFeature.f_191773_.fieldOf("apatite_ore").forGetter(ForestryBiomeModifier::apatiteOre), (App)PlacedFeature.f_191773_.fieldOf("tin_ore").forGetter(ForestryBiomeModifier::tinOre)).apply((Applicative)instance, ForestryBiomeModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            if (biome.m_203656_(BiomeTags.f_215817_)) {
                if (((Boolean)ForestryConfig.SERVER.spawnTinOre.get()).booleanValue()) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, this.tinOre);
                }
                if (((Boolean)ForestryConfig.SERVER.spawnApatiteOre.get()).booleanValue()) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, this.apatiteOre);
                }
            }
            IClimateManager climates = IForestryApi.INSTANCE.getClimateManager();
            TemperatureType temperature = climates.getTemperature(biome);
            HumidityType humidity = climates.getHumidity(biome);
            builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.tree);
            for (IHive hive : IForestryApi.INSTANCE.getHiveManager().getHives()) {
                if (!hive.isGoodBiome(biome) || !hive.isGoodTemperature(temperature) || !hive.isGoodHumidity(humidity)) continue;
                builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.hive);
                return;
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return CODEC;
    }
}

