/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.tiles;

import forestry.api.core.ForestryError;
import forestry.api.fuels.FuelManager;
import forestry.core.features.CoreItems;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.TemperatureState;
import forestry.energy.features.EnergyTiles;
import forestry.energy.inventory.InventoryEnginePeat;
import forestry.energy.menu.PeatEngineMenu;
import forestry.energy.tiles.EngineBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class PeatEngineBlockEntity
extends EngineBlockEntity
implements WorldlyContainer {
    private ItemStack fuel = ItemStack.f_41583_;
    private int burnTime;
    private int totalBurnTime;
    private int ashProduction;
    private final int ashForItem;

    public PeatEngineBlockEntity(BlockPos pos, BlockState state) {
        super(EnergyTiles.PEAT_ENGINE.tileType(), pos, state, "engine.copper", 10000, 200000);
        this.ashForItem = 7500;
        this.setInternalInventory(new InventoryEnginePeat(this));
    }

    private int getFuelSlot() {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.m_8020_(0).m_41619_()) {
            return -1;
        }
        if (PeatEngineBlockEntity.determineFuelValue(inventory.m_8020_(0)) > 0) {
            return 0;
        }
        return -1;
    }

    private int getFreeWasteSlot() {
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int i = 1; i <= 4; ++i) {
            ItemStack waste = inventory.m_8020_(i);
            if (waste.m_41619_()) {
                return i;
            }
            if (!CoreItems.ASH.itemEqual(waste) || waste.m_41613_() >= waste.m_41741_()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.updateOnInterval(40)) {
            int fuelSlot = this.getFuelSlot();
            boolean hasFuel = fuelSlot >= 0 && PeatEngineBlockEntity.determineBurnDuration(this.getInternalInventory().m_8020_(fuelSlot)) > 0;
            this.getErrorLogic().setCondition(!hasFuel, ForestryError.NO_FUEL);
        }
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (this.burnTime > 0) {
            --this.burnTime;
            this.addAsh(1);
            if (this.isRedstoneActivated()) {
                this.currentOutput = PeatEngineBlockEntity.determineFuelValue(this.fuel);
                this.energyStorage.generateEnergy(this.currentOutput);
                this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
            }
        } else if (this.isRedstoneActivated()) {
            int fuelSlot = this.getFuelSlot();
            int wasteSlot = this.getFreeWasteSlot();
            if (fuelSlot >= 0 && wasteSlot >= 0) {
                IInventoryAdapter inventory = this.getInternalInventory();
                ItemStack fuelStack = inventory.m_8020_(fuelSlot);
                this.burnTime = this.totalBurnTime = PeatEngineBlockEntity.determineBurnDuration(fuelStack);
                if (this.burnTime > 0 && !fuelStack.m_41619_()) {
                    this.fuel = fuelStack.m_41777_();
                    this.m_7407_(fuelSlot, 1);
                }
            }
        }
    }

    @Override
    public void dissipateHeat() {
        TemperatureState tempState;
        if (this.heat <= 0) {
            return;
        }
        int loss = 0;
        if (!this.isBurning()) {
            ++loss;
        }
        if ((tempState = this.getTemperatureState()) == TemperatureState.OVERHEATING || tempState == TemperatureState.OPERATING_TEMPERATURE) {
            ++loss;
        }
        this.heat -= loss;
    }

    @Override
    public void generateHeat() {
        int heatToAdd = 0;
        if (this.isBurning()) {
            ++heatToAdd;
            if ((double)this.energyStorage.getEnergyStored() / (double)this.energyStorage.getMaxEnergyStored() > 0.5) {
                ++heatToAdd;
            }
        }
        this.addHeat(heatToAdd);
    }

    private void addAsh(int amount) {
        this.ashProduction += amount;
        if (this.ashProduction < this.ashForItem) {
            return;
        }
        int wasteSlot = this.getFreeWasteSlot();
        if (wasteSlot >= 0) {
            IInventoryAdapter inventory = this.getInternalInventory();
            ItemStack wasteStack = inventory.m_8020_(wasteSlot);
            if (wasteStack.m_41619_()) {
                inventory.m_6836_(wasteSlot, CoreItems.ASH.stack());
            } else {
                wasteStack.m_41769_(1);
            }
        }
        this.ashProduction = 0;
    }

    private static int determineFuelValue(ItemStack fuel) {
        if (FuelManager.peatEngineFuel.containsKey(fuel)) {
            return FuelManager.peatEngineFuel.get(fuel).powerPerCycle();
        }
        return 0;
    }

    private static int determineBurnDuration(ItemStack fuel) {
        if (FuelManager.peatEngineFuel.containsKey(fuel)) {
            return FuelManager.peatEngineFuel.get(fuel).burnDuration();
        }
        return 0;
    }

    @Override
    public boolean isBurning() {
        return this.mayBurn() && this.burnTime > 0;
    }

    @Override
    public int getBurnTimeRemainingScaled(int i) {
        if (this.totalBurnTime == 0) {
            return 0;
        }
        return this.burnTime * i / this.totalBurnTime;
    }

    @Override
    public boolean hasFuelMin(float percentage) {
        int fuelSlot = this.getFuelSlot();
        if (fuelSlot < 0) {
            return false;
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        return (float)inventory.m_8020_(fuelSlot).m_41613_() / (float)inventory.m_8020_(fuelSlot).m_41741_() > percentage;
    }

    @Override
    public void m_142466_(CompoundTag compoundNBT) {
        super.m_142466_(compoundNBT);
        if (compoundNBT.m_128441_("EngineFuelItemStack")) {
            CompoundTag fuelItemNbt = compoundNBT.m_128469_("EngineFuelItemStack");
            this.fuel = ItemStack.m_41712_((CompoundTag)fuelItemNbt);
        }
        this.burnTime = compoundNBT.m_128451_("EngineBurnTime");
        this.totalBurnTime = compoundNBT.m_128451_("EngineTotalTime");
        if (compoundNBT.m_128441_("AshProduction")) {
            this.ashProduction = compoundNBT.m_128451_("AshProduction");
        }
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (!this.fuel.m_41619_()) {
            nbt.m_128365_("EngineFuelItemStack", (Tag)this.fuel.serializeNBT());
        }
        nbt.m_128405_("EngineBurnTime", this.burnTime);
        nbt.m_128405_("EngineTotalTime", this.totalBurnTime);
        nbt.m_128405_("AshProduction", this.ashProduction);
    }

    @Override
    public void writeGuiData(FriendlyByteBuf data) {
        super.writeGuiData(data);
        data.writeInt(this.burnTime);
        data.writeInt(this.totalBurnTime);
    }

    @Override
    public void readGuiData(FriendlyByteBuf data) {
        super.readGuiData(data);
        this.burnTime = data.readInt();
        this.totalBurnTime = data.readInt();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory pPlayerInventory, Player pPlayer) {
        return new PeatEngineMenu(windowId, pPlayerInventory, this);
    }
}

