/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.inventory;

import forestry.core.fluids.FluidHelper;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.factory.tiles.TileBottler;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.ForgeRegistries;

public class InventoryBottler
extends InventoryAdapterTile<TileBottler> {
    public static final short SLOT_INPUT_FULL_CONTAINER = 0;
    public static final short SLOT_INPUT_EMPTY_CONTAINER = 1;
    public static final short SLOT_EMPTYING_PROCESSING = 2;
    public static final short SLOT_FILLING_PROCESSING = 3;
    public static final short SLOT_OUTPUT_EMPTY_CONTAINER = 4;
    public static final short SLOT_OUTPUT_FULL_CONTAINER = 5;

    public InventoryBottler(TileBottler tileBottler) {
        super(tileBottler, 6, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack stack) {
        if (slotIndex == 1) {
            return FluidHelper.isFillableContainerWithRoom(stack);
        }
        if (slotIndex == 0) {
            Optional fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
            return fluidStack.map(f -> ForgeRegistries.FLUIDS.containsValue((Object)f.getFluid())).orElse(false);
        }
        return false;
    }

    @Override
    public boolean m_7157_(int slotIndex, ItemStack itemstack, Direction side) {
        return slotIndex == 4 || slotIndex == 5;
    }
}

