/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.api.core.Product;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.core.utils.JsonUtil;
import forestry.factory.features.FactoryRecipeTypes;
import forestry.factory.recipes.RecipeSerializers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public class CentrifugeRecipe
implements ICentrifugeRecipe {
    private final ResourceLocation id;
    private final int processingTime;
    private final Ingredient input;
    private final List<Product> products;

    public CentrifugeRecipe(ResourceLocation id, int processingTime, Ingredient input, List<Product> products) {
        Preconditions.checkNotNull((Object)id, (Object)"Recipe identifier cannot be null");
        this.id = id;
        this.processingTime = processingTime;
        this.input = input;
        this.products = products;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public List<ItemStack> getProducts(RandomSource random) {
        ArrayList<ItemStack> products = new ArrayList<ItemStack>();
        for (Product entry : this.products) {
            float probability = entry.chance();
            if ((double)probability >= 1.0) {
                products.add(entry.createStack());
                continue;
            }
            if (!(random.m_188501_() < probability)) continue;
            products.add(entry.createStack());
        }
        return products;
    }

    @Override
    public List<Product> getAllProducts() {
        return this.products;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return FactoryRecipeTypes.CENTRIFUGE.serializer();
    }

    @Override
    public RecipeType<?> m_6671_() {
        return FactoryRecipeTypes.CENTRIFUGE.type();
    }

    public static class Serializer
    implements RecipeSerializer<CentrifugeRecipe> {
        public CentrifugeRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int processingTime = GsonHelper.m_13927_((JsonObject)json, (String)"time");
            Ingredient input = RecipeSerializers.deserialize(json.get("input"));
            NonNullList outputs = NonNullList.m_122779_();
            for (JsonElement element : GsonHelper.m_13933_((JsonObject)json, (String)"products")) {
                outputs.add((Object)JsonUtil.deserialize(Product.CODEC, element));
            }
            return new CentrifugeRecipe(recipeId, processingTime, input, (List<Product>)outputs);
        }

        public CentrifugeRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int processingTime = buffer.m_130242_();
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            List<Product> outputs = RecipeSerializers.read(buffer, Product::fromNetwork);
            return new CentrifugeRecipe(recipeId, processingTime, input, outputs);
        }

        public void toNetwork(FriendlyByteBuf buffer, CentrifugeRecipe recipe) {
            buffer.m_130130_(recipe.processingTime);
            recipe.input.m_43923_(buffer);
            RecipeSerializers.write(buffer, recipe.products, Product::toNetwork);
        }
    }
}

