/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.fuels.FuelManager;
import forestry.api.fuels.RainSubstrate;
import forestry.core.render.ParticleRender;
import forestry.core.tiles.TileMill;
import forestry.factory.features.FactoryTiles;
import forestry.factory.inventory.InventoryRainmaker;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ServerLevelData;

public class TileMillRainmaker
extends TileMill {
    private int duration;
    private boolean reverse;

    public TileMillRainmaker(BlockPos pos, BlockState state) {
        super(FactoryTiles.RAINMAKER.tileType(), pos, state);
        this.speed = 0.01f;
        this.setInternalInventory(new InventoryRainmaker(this));
    }

    @Override
    public void openGui(ServerPlayer player, InteractionHand hand, BlockPos pos) {
        if (!player.m_9236_().f_46443_) {
            RainSubstrate substrate;
            ItemStack heldItem = player.m_21120_(hand);
            if (FuelManager.rainSubstrate.containsKey(heldItem) && this.charge == 0 && ItemStack.m_41656_((ItemStack)(substrate = FuelManager.rainSubstrate.get(heldItem)).item(), (ItemStack)heldItem)) {
                this.addCharge(substrate);
                if (!player.m_7500_()) {
                    heldItem.m_41774_(1);
                }
            }
            this.sendNetworkUpdate();
        }
    }

    @Override
    public void m_142466_(CompoundTag compoundNBT) {
        super.m_142466_(compoundNBT);
        this.charge = compoundNBT.m_128451_("Charge");
        this.progress = compoundNBT.m_128457_("Progress");
        this.stage = compoundNBT.m_128451_("Stage");
        this.duration = compoundNBT.m_128451_("Duration");
        this.reverse = compoundNBT.m_128471_("Reverse");
    }

    @Override
    public void m_183515_(CompoundTag compoundNBT) {
        super.m_183515_(compoundNBT);
        compoundNBT.m_128405_("Charge", this.charge);
        compoundNBT.m_128350_("Progress", this.progress);
        compoundNBT.m_128405_("Stage", this.stage);
        compoundNBT.m_128405_("Duration", this.duration);
        compoundNBT.m_128379_("Reverse", this.reverse);
    }

    public void addCharge(RainSubstrate substrate) {
        this.charge = 1;
        this.speed = substrate.speed();
        this.duration = substrate.duration();
        this.reverse = substrate.reverse();
        this.sendNetworkUpdate();
    }

    @Override
    public void activate(Level level, BlockPos pos) {
        if (level.f_46443_) {
            level.m_5594_(null, pos, SoundEvents.f_12090_, SoundSource.WEATHER, 10000.0f, 0.8f + level.f_46441_.m_188501_() * 0.2f);
            float f = (float)pos.m_123341_() + 0.5f;
            float f1 = (float)pos.m_123342_() + level.f_46441_.m_188501_() * 6.0f / 16.0f;
            float f2 = (float)pos.m_123343_() + 0.5f;
            float f3 = 0.52f;
            float f4 = level.f_46441_.m_188501_() * 0.6f - 0.3f;
            ParticleRender.addEntityExplodeFX(level, f - f3, f1, f2 + f4);
            ParticleRender.addEntityExplodeFX(level, f + f3, f1, f2 + f4);
            ParticleRender.addEntityExplodeFX(level, f + f4, f1, f2 - f3);
            ParticleRender.addEntityExplodeFX(level, f + f4, f1, f2 + f3);
        } else {
            if (this.reverse) {
                level.m_6106_().m_5565_(false);
            } else {
                level.m_6106_().m_5565_(true);
                ((ServerLevelData)level.m_6106_()).m_6399_(this.duration);
            }
            this.charge = 0;
            this.duration = 0;
            this.reverse = false;
            this.sendNetworkUpdate();
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return null;
    }

    @Override
    protected boolean hasGui() {
        return false;
    }
}

