/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.IForestryApi;
import forestry.api.circuits.ForestryCircuitSocketTypes;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.core.ForestryError;
import forestry.api.core.IErrorLogic;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.core.circuits.ISocketable;
import forestry.core.circuits.ISpeedUpgradable;
import forestry.core.fluids.StandardTank;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.RecipeUtils;
import forestry.factory.features.FactoryTiles;
import forestry.factory.gui.ContainerSqueezer;
import forestry.factory.inventory.InventorySqueezer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileSqueezer
extends TilePowered
implements ISocketable,
WorldlyContainer,
ILiquidTankTile,
ISpeedUpgradable {
    private static final int TICKS_PER_RECIPE_TIME = 1;
    private static final int ENERGY_PER_WORK_CYCLE = 2000;
    private static final int ENERGY_PER_RECIPE_TIME = 200;
    private final InventoryAdapter sockets = new InventoryAdapter(1, "sockets");
    private final TankManager tankManager;
    private final StandardTank productTank;
    private final InventorySqueezer inventory = new InventorySqueezer(this);
    @Nullable
    private ISqueezerRecipe currentRecipe;

    public TileSqueezer(BlockPos pos, BlockState state) {
        super(FactoryTiles.SQUEEZER.tileType(), pos, state, 1100, 40000);
        this.setInternalInventory(this.inventory);
        this.productTank = new StandardTank(10000, false, true);
        this.tankManager = new TankManager(this, this.productTank);
    }

    @Override
    public void m_183515_(CompoundTag compoundNBT) {
        super.m_183515_(compoundNBT);
        this.tankManager.write(compoundNBT);
        this.sockets.write(compoundNBT);
    }

    @Override
    public void m_142466_(CompoundTag compoundNBT) {
        ICircuitBoard chipset;
        super.m_142466_(compoundNBT);
        this.tankManager.read(compoundNBT);
        this.sockets.read(compoundNBT);
        ItemStack chip = this.sockets.m_8020_(0);
        if (!chip.m_41619_() && (chipset = IForestryApi.INSTANCE.getCircuitManager().getCircuitBoard(chip)) != null) {
            chipset.onLoad(this);
        }
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(FriendlyByteBuf data) {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void writeGuiData(FriendlyByteBuf data) {
        super.writeGuiData(data);
        this.sockets.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readGuiData(FriendlyByteBuf data) {
        super.readGuiData(data);
        this.sockets.readData(data);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        FluidStack fluid;
        super.serverTick(level, pos, state);
        if (this.updateOnInterval(20) && !(fluid = this.productTank.getFluid()).isEmpty()) {
            this.inventory.fillContainers(fluid, this.tankManager);
        }
    }

    @Override
    public boolean workCycle() {
        if (this.currentRecipe == null) {
            return false;
        }
        if (!this.inventory.removeResources(this.currentRecipe.getInputs())) {
            return false;
        }
        FluidStack resultFluid = this.currentRecipe.getFluidOutput();
        this.productTank.fillInternal(resultFluid, IFluidHandler.FluidAction.EXECUTE);
        if (!this.currentRecipe.getRemnants().m_41619_() && this.f_58857_.f_46441_.m_188501_() < this.currentRecipe.getRemnantsChance()) {
            ItemStack remnant = this.currentRecipe.getRemnants().m_41777_();
            this.inventory.addRemnant(remnant, true);
        }
        return true;
    }

    private boolean checkRecipe() {
        ISqueezerRecipe matchingRecipe = null;
        if (this.inventory.hasResources()) {
            List<ItemStack> resources = this.inventory.getResources();
            boolean containsSets = false;
            if (this.currentRecipe != null) {
                InventoryMapper inventory = new InventoryMapper((Container)this, 0, 9);
                containsSets = InventoryUtil.consumeIngredients(inventory, this.currentRecipe.getInputs(), null, false, false, false);
            }
            if ((matchingRecipe = this.currentRecipe != null && containsSets ? this.currentRecipe : RecipeUtils.getSqueezerRecipe(this.m_58904_().m_7465_(), resources)) == null) {
                for (ItemStack resource : resources) {
                    if (matchingRecipe != null) continue;
                    matchingRecipe = RecipeUtils.getSqueezerContainerRecipe(this.m_58904_().m_7465_(), resource);
                }
            }
        }
        if (this.currentRecipe != matchingRecipe) {
            this.currentRecipe = matchingRecipe;
            if (this.currentRecipe != null) {
                int recipeTime = this.currentRecipe.getProcessingTime();
                this.setTicksPerWorkCycle(recipeTime * 1);
                this.setEnergyPerWorkCycle(recipeTime * 200);
            }
        }
        this.getErrorLogic().setCondition(this.currentRecipe == null, ForestryError.NO_RECIPE);
        return this.currentRecipe != null;
    }

    @Override
    public boolean hasWork() {
        this.checkRecipe();
        boolean hasResources = this.inventory.hasResources();
        boolean hasRecipe = true;
        boolean canFill = true;
        boolean canAdd = true;
        if (hasResources) {
            boolean bl = hasRecipe = this.currentRecipe != null;
            if (hasRecipe) {
                FluidStack resultFluid = this.currentRecipe.getFluidOutput();
                boolean bl2 = canFill = this.productTank.fillInternal(resultFluid, IFluidHandler.FluidAction.SIMULATE) == resultFluid.getAmount();
                if (!this.currentRecipe.getRemnants().m_41619_()) {
                    canAdd = this.inventory.addRemnant(this.currentRecipe.getRemnants(), false);
                }
            }
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasResources, ForestryError.NO_RESOURCE);
        errorLogic.setCondition(!hasRecipe, ForestryError.NO_RECIPE);
        errorLogic.setCondition(!canFill, ForestryError.NO_SPACE_TANK);
        errorLogic.setCondition(!canAdd, ForestryError.NO_SPACE_INVENTORY);
        return hasResources && hasRecipe && canFill && canAdd;
    }

    @Override
    public TankRenderInfo getProductTankInfo() {
        return new TankRenderInfo((IFluidTank)this.productTank);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public int getSocketCount() {
        return this.sockets.m_6643_();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return this.sockets.m_8020_(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        if (stack.m_41619_() || IForestryApi.INSTANCE.getCircuitManager().isCircuitBoard(stack)) {
            ICircuitBoard chipset;
            if (!this.sockets.m_8020_(slot).m_41619_() && IForestryApi.INSTANCE.getCircuitManager().isCircuitBoard(this.sockets.m_8020_(slot)) && (chipset = IForestryApi.INSTANCE.getCircuitManager().getCircuitBoard(this.sockets.m_8020_(slot))) != null) {
                chipset.onRemoval(this);
            }
            this.sockets.m_6836_(slot, stack);
            if (!stack.m_41619_() && (chipset = IForestryApi.INSTANCE.getCircuitManager().getCircuitBoard(stack)) != null) {
                chipset.onInsertion(this);
            }
        }
    }

    @Override
    public ResourceLocation getSocketType() {
        return ForestryCircuitSocketTypes.MACHINE;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(() -> this.tankManager).cast();
        }
        return super.getCapability(capability, facing);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ContainerSqueezer(windowId, inv, this);
    }
}

