/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.compat;

import forestry.api.IForestryApi;
import forestry.api.circuits.CircuitHolder;
import forestry.api.circuits.ICircuit;
import forestry.api.farming.IFarmCircuit;
import forestry.api.modules.ForestryModuleIds;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.features.CoreItems;
import forestry.farming.compat.FarmingInfoRecipe;
import forestry.farming.compat.FarmingInfoRecipeCategory;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class FarmingJeiPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ForestryModuleIds.FARMING;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new FarmingInfoRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(FarmingInfoRecipeCategory.TYPE, FarmingJeiPlugin.getRecipes());
    }

    public static List<FarmingInfoRecipe> getRecipes() {
        ArrayList<FarmingInfoRecipe> info = new ArrayList<FarmingInfoRecipe>();
        for (CircuitHolder holder : IForestryApi.INSTANCE.getCircuitManager().getCircuitHolders()) {
            IFarmCircuit circuit;
            ICircuit iCircuit = holder.circuit();
            if (!(iCircuit instanceof IFarmCircuit) || !(circuit = (IFarmCircuit)iCircuit).isManual()) continue;
            info.add(new FarmingInfoRecipe(holder.stack(), circuit.getProperties(), circuit));
        }
        return info;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CoreItems.CIRCUITBOARDS.get(EnumCircuitBoardType.INTRICATE)), new RecipeType[]{FarmingInfoRecipeCategory.TYPE});
    }
}

