/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gui;

import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.utils.ResourceUtil;
import forestry.core.utils.StringUtil;
import forestry.farming.gui.IFarmLedgerDelegate;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FarmLedger
extends Ledger {
    private final IFarmLedgerDelegate delegate;

    public FarmLedger(LedgerManager ledgerManager, IFarmLedgerDelegate delegate) {
        super(ledgerManager, "farm");
        this.delegate = delegate;
        int titleHeight = StringUtil.getLineHeight(this.maxTextWidth, new FormattedText[]{this.getTooltip()});
        this.maxHeight = titleHeight + 110;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiGraphics graphics, int y, int x) {
        this.drawBackground(graphics, y, x);
        int xIcon = x + 3;
        int xBody = x + 10;
        int xHeader = x + 22;
        TextureAtlasSprite textureAtlasSprite = ResourceUtil.getBlockSprite("item/water_bucket");
        this.drawSprite(graphics, textureAtlasSprite, xIcon, y += 4, TextureAtlas.f_118259_);
        y += 4;
        if (!this.isFullyOpened()) {
            return;
        }
        y += this.drawHeader(graphics, (Component)Component.m_237115_((String)"for.gui.hydration"), xHeader, y);
        y += 4;
        y += this.drawSubheader(graphics, (Component)Component.m_237115_((String)"for.gui.hydr.heat").m_130946_(":"), xBody, y);
        y += 3;
        y += this.drawText(graphics, StringUtil.floatAsPercent(this.delegate.getHydrationTempModifier()), xBody, y);
        y += 3;
        y += this.drawSubheader(graphics, (Component)Component.m_237115_((String)"for.gui.hydr.humid").m_130946_(":"), xBody, y);
        y += 3;
        y += this.drawText(graphics, StringUtil.floatAsPercent(this.delegate.getHydrationHumidModifier()), xBody, y);
        y += 3;
        y += this.drawSubheader(graphics, (Component)Component.m_237115_((String)"for.gui.hydr.rainfall").m_130946_(":"), xBody, y);
        y += 3;
        y += this.drawText(graphics, StringUtil.floatAsPercent(this.delegate.getHydrationRainfallModifier()) + " (" + this.delegate.getDrought() + " d)", xBody, y);
        y += 3;
        y += this.drawSubheader(graphics, (Component)Component.m_237115_((String)"for.gui.hydr.overall").m_130946_(":"), xBody, y);
        this.drawText(graphics, StringUtil.floatAsPercent(this.delegate.getHydrationModifier()), xBody, y += 3);
    }

    @Override
    public Component getTooltip() {
        float hydrationModifier = this.delegate.getHydrationModifier();
        return Component.m_237113_((String)(StringUtil.floatAsPercent(hydrationModifier) + " ")).m_7220_((Component)Component.m_237115_((String)"for.gui.hydration"));
    }
}

