/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmType;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.FarmLogicWatered;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class FarmLogicGourd
extends FarmLogicWatered {
    public FarmLogicGourd(IFarmType properties, boolean isManual) {
        super(properties, isManual);
    }

    @Override
    protected boolean maintainCrops(Level world, IFarmHousing farmHousing, BlockPos pos, Direction direction, int extent) {
        BlockPos position;
        for (int i = 0; i < extent && world.m_46805_(position = this.translateWithOffset(pos, direction, i)); ++i) {
            BlockState groundState;
            BlockState state = world.m_8055_(position);
            if (!world.m_46859_(position) && !BlockUtil.isReplaceableBlock(state, world, position) || !this.isValidPosition(farmHousing, direction, position, FarmLogicWatered.CultivationType.CROP) || !this.isAcceptedSoil(groundState = world.m_8055_(position.m_7495_()))) continue;
            return this.trySetCrop(world, farmHousing, position, direction);
        }
        return false;
    }

    private boolean trySetCrop(Level world, IFarmHousing farmHousing, BlockPos position, Direction direction) {
        for (IFarmable candidate : this.getFarmables()) {
            if (!farmHousing.plantGermling(candidate, world, position, direction)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isValidPosition(IFarmHousing housing, Direction direction, BlockPos position, FarmLogicWatered.CultivationType type) {
        BlockPos farmLocation = housing.getFarmCorner(direction).m_121945_(direction);
        int xVal = farmLocation.m_123341_() & 1;
        int zVal = farmLocation.m_123343_() & 1;
        boolean uneven = (position.m_123341_() & 1) != xVal ^ (position.m_123343_() & 1) != zVal;
        return type == FarmLogicWatered.CultivationType.WATER != uneven;
    }
}

