/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmType;
import forestry.api.farming.Soil;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.FarmLogicCocoa;
import forestry.farming.logic.FarmLogicSoil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public abstract class FarmLogicWatered
extends FarmLogicSoil {
    private static final FluidStack STACK_WATER = new FluidStack((Fluid)Fluids.f_76193_, 1000);

    public FarmLogicWatered(IFarmType properties, boolean isManual) {
        super(properties, isManual);
    }

    @Override
    public boolean cultivate(Level level, IFarmHousing farmHousing, BlockPos pos, Direction direction, int extent) {
        if (this.maintainSoil(level, farmHousing, pos, direction, extent)) {
            return true;
        }
        if (!this.isManual && this.maintainWater(level, farmHousing, pos, direction, extent)) {
            return true;
        }
        return this.maintainCrops(level, farmHousing, pos.m_7494_(), direction, extent);
    }

    protected boolean isValidPosition(IFarmHousing housing, Direction direction, BlockPos pos, CultivationType type) {
        return true;
    }

    private boolean maintainSoil(Level world, IFarmHousing farmHousing, BlockPos pos, Direction direction, int extent) {
        if (!farmHousing.canPlantSoil(this.isManual)) {
            return false;
        }
        block0: for (Soil soil : this.getSoils()) {
            BlockPos position;
            NonNullList resources = NonNullList.m_122779_();
            resources.add((Object)soil.resource());
            for (int i = 0; i < extent && world.m_46805_(position = this.translateWithOffset(pos, direction, i)); ++i) {
                BlockState state = world.m_8055_(position);
                if (!this.isValidPosition(farmHousing, direction, position, CultivationType.SOIL) || !BlockUtil.isBreakableBlock(state, world, pos) || this.isAcceptedSoil(state) || this.isWaterSourceBlock(world, position) || !farmHousing.getFarmInventory().hasResources((List<ItemStack>)resources)) continue;
                BlockPos platformPosition = position.m_7495_();
                if (!farmHousing.isValidPlatform(world, platformPosition)) continue block0;
                if (!BlockUtil.isReplaceableBlock(state, world, position)) {
                    BlockUtil.getBlockDrops((LevelAccessor)world, position).forEach(farmHousing::addPendingProduct);
                    world.m_7471_(position, false);
                    return FarmLogicCocoa.trySetSoil(world, farmHousing, position, soil.resource(), soil.soilState());
                }
                if (this.isManual) continue;
                if (this.trySetWater(world, farmHousing, position)) {
                    return true;
                }
                return FarmLogicCocoa.trySetSoil(world, farmHousing, position, soil.resource(), soil.soilState());
            }
        }
        return false;
    }

    private boolean maintainWater(Level world, IFarmHousing farmHousing, BlockPos pos, Direction direction, int extent) {
        BlockPos position;
        for (int i = 0; i < extent && world.m_46805_(position = this.translateWithOffset(pos, direction, i)); ++i) {
            if (!this.isValidPosition(farmHousing, direction, position, CultivationType.WATER)) continue;
            BlockPos platformPosition = position.m_7495_();
            if (!farmHousing.isValidPlatform(world, platformPosition)) break;
            if (!BlockUtil.isBreakableBlock(world, pos) || !this.trySetWater(world, farmHousing, position)) continue;
            return true;
        }
        return false;
    }

    protected boolean maintainCrops(Level world, IFarmHousing farmHousing, BlockPos pos, Direction direction, int extent) {
        return false;
    }

    private boolean trySetWater(Level world, IFarmHousing farmHousing, BlockPos position) {
        if (this.isWaterSourceBlock(world, position)) {
            return false;
        }
        Pair<WaterStatus, BlockPos> waterPair = this.canPlaceWater(world, position);
        WaterStatus status = (WaterStatus)((Object)waterPair.getKey());
        if (status == WaterStatus.NO_WATER) {
            if (!farmHousing.hasLiquid(STACK_WATER)) {
                return false;
            }
            BlockUtil.getBlockDrops((LevelAccessor)world, position).forEach(farmHousing::addPendingProduct);
            BlockUtil.setBlockWithPlaceSound(world, position, Blocks.f_49990_.m_49966_());
            farmHousing.removeLiquid(STACK_WATER);
            return true;
        }
        if (status == WaterStatus.ICE) {
            BlockUtil.setBlockWithPlaceSound(world, (BlockPos)waterPair.getValue(), Blocks.f_49990_.m_49966_());
        }
        return false;
    }

    private Pair<WaterStatus, BlockPos> canPlaceWater(Level world, BlockPos position) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                BlockPos offsetPosition = position.m_7918_(x, 0, z);
                if (this.isWaterSourceBlock(world, offsetPosition)) {
                    return Pair.of((Object)((Object)WaterStatus.WATER_SOURCE), (Object)BlockPos.f_121853_);
                }
                if (!this.isIceBlock(world, offsetPosition) || this.couldFlow(world, offsetPosition)) continue;
                return Pair.of((Object)((Object)WaterStatus.ICE), (Object)offsetPosition);
            }
        }
        if (this.couldFlow(world, position)) {
            return Pair.of((Object)((Object)WaterStatus.AIR), (Object)BlockPos.f_121853_);
        }
        return Pair.of((Object)((Object)WaterStatus.NO_WATER), (Object)BlockPos.f_121853_);
    }

    private boolean couldFlow(Level world, BlockPos position) {
        BlockPos offsetPosition;
        for (int x = -1; x <= 1; ++x) {
            offsetPosition = position.m_7918_(x, 0, 0);
            if (!world.m_46859_(offsetPosition)) continue;
            return true;
        }
        for (int z = -1; z <= 1; ++z) {
            offsetPosition = position.m_7918_(0, 0, z);
            if (!world.m_46859_(offsetPosition)) continue;
            return true;
        }
        return false;
    }

    public static enum CultivationType {
        WATER,
        SOIL,
        CROP;

    }

    private static enum WaterStatus {
        NO_WATER,
        WATER_SOURCE,
        AIR,
        ICE;

    }
}

