/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.farmables;

import com.google.common.base.Preconditions;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.ModUtil;
import forestry.farming.logic.crops.CropDestroy;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FarmableAgingCrop
implements IFarmable {
    protected final ItemStack germling;
    protected final Block cropBlock;
    protected final Property<Integer> ageProperty;
    protected final int minHarvestAge;
    @Nullable
    protected final Integer replantAge;
    protected final ItemStack[] products;

    public FarmableAgingCrop(Item germling, Block cropBlock, Property<Integer> ageProperty, int minHarvestAge) {
        this(germling, cropBlock, new ItemStack[0], ageProperty, minHarvestAge, null);
    }

    public FarmableAgingCrop(Item germling, Block cropBlock, Property<Integer> ageProperty, int minHarvestAge, @Nullable Integer replantAge) {
        this(germling, cropBlock, new ItemStack[0], ageProperty, minHarvestAge, replantAge);
    }

    public FarmableAgingCrop(Item germling, Block cropBlock, ItemStack product, Property<Integer> ageProperty, int minHarvestAge) {
        this(germling, cropBlock, new ItemStack[]{product}, ageProperty, minHarvestAge, null);
    }

    public FarmableAgingCrop(Item germling, Block cropBlock, ItemStack product, Property<Integer> ageProperty, int minHarvestAge, @Nullable Integer replantAge) {
        this(germling, cropBlock, new ItemStack[]{product}, ageProperty, minHarvestAge, replantAge);
    }

    public FarmableAgingCrop(Item germling, Block cropBlock, ItemStack[] products, Property<Integer> ageProperty, int minHarvestAge) {
        this(germling, cropBlock, products, ageProperty, minHarvestAge, null);
    }

    public FarmableAgingCrop(Item germling, Block cropBlock, ItemStack[] products, Property<Integer> ageProperty, int minHarvestAge, @Nullable Integer replantAge) {
        ModUtil.checkNotEmpty(germling);
        ModUtil.checkNotEmpty(cropBlock);
        Preconditions.checkNotNull(ageProperty);
        Preconditions.checkNotNull((Object)products);
        this.germling = new ItemStack((ItemLike)germling);
        this.cropBlock = cropBlock;
        this.ageProperty = ageProperty;
        this.minHarvestAge = minHarvestAge;
        this.replantAge = replantAge;
        this.products = products;
    }

    @Override
    public boolean isSaplingAt(Level level, BlockPos pos, BlockState state) {
        return state.m_60734_() == this.cropBlock && (Integer)state.m_61143_(this.ageProperty) <= this.minHarvestAge;
    }

    @Override
    @Nullable
    public ICrop getCropAt(Level level, BlockPos pos, BlockState state) {
        if (state.m_60734_() != this.cropBlock) {
            return null;
        }
        if ((Integer)state.m_61143_(this.ageProperty) < this.minHarvestAge) {
            return null;
        }
        BlockState replantState = this.getReplantState(state);
        return new CropDestroy(level, state, pos, replantState, this.germling);
    }

    @Nullable
    protected BlockState getReplantState(BlockState blockState) {
        if (this.replantAge == null) {
            return null;
        }
        return (BlockState)blockState.m_61124_(this.ageProperty, (Comparable)this.replantAge);
    }

    @Override
    public boolean isGermling(ItemStack stack) {
        return ItemStack.m_41656_((ItemStack)this.germling, (ItemStack)stack);
    }

    @Override
    public void addGermlings(Consumer<ItemStack> accumulator) {
        accumulator.accept(this.germling);
    }

    @Override
    public void addProducts(Consumer<ItemStack> accumulator) {
        for (ItemStack product : this.products) {
            accumulator.accept(product);
        }
    }

    @Override
    public boolean plantSaplingAt(Player player, ItemStack germling, Level level, BlockPos pos) {
        BlockState plantedState = (BlockState)this.cropBlock.m_49966_().m_61124_(this.ageProperty, (Comparable)Integer.valueOf(0));
        return BlockUtil.setBlockWithPlaceSound(level, pos, plantedState);
    }

    @Override
    public boolean isWindfall(ItemStack stack) {
        return false;
    }
}

