/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import forestry.api.IForestryApi;
import forestry.api.core.HumidityType;
import forestry.api.core.IProduct;
import forestry.api.core.TemperatureType;
import forestry.api.genetics.ClimateHelper;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.alleles.AllelePair;
import forestry.api.genetics.alleles.ButterflyChromosomes;
import forestry.api.genetics.alleles.IIntegerChromosome;
import forestry.api.lepidopterology.IButterflyCocoon;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.api.lepidopterology.IEntityButterfly;
import forestry.api.lepidopterology.genetics.ButterflyLifeStage;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.api.lepidopterology.genetics.IButterflySpecies;
import forestry.api.lepidopterology.genetics.IButterflySpeciesType;
import forestry.core.genetics.IndividualLiving;
import forestry.core.genetics.mutations.Mutation;
import forestry.core.utils.SpeciesUtil;
import forestry.lepidopterology.ModuleLepidopterology;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class Butterfly
extends IndividualLiving<IButterflySpecies, IButterfly, IButterflySpeciesType>
implements IButterfly {
    private static final RandomSource rand = RandomSource.m_216327_();
    public static final Codec<Butterfly> CODEC = RecordCodecBuilder.create(instance -> {
        Codec<IGenome> genomeCodec = ((IButterflySpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get()).getKaryotype().getGenomeCodec();
        return IndividualLiving.livingFields(instance, genomeCodec).apply((Applicative)instance, Butterfly::new);
    });

    public Butterfly(IGenome genome) {
        super(genome);
    }

    private Butterfly(IGenome genome, Optional<IGenome> mate, boolean analyzed, int health, int maxHealth) {
        super(genome, mate, analyzed, health, maxHealth);
    }

    @Override
    public Component getDisplayName() {
        return ((IButterflySpecies)this.species).getDisplayName();
    }

    @Override
    public boolean canSpawn(Level level, double x, double y, double z) {
        if (!this.canFly(level)) {
            return false;
        }
        BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        Holder biome = level.m_204166_(pos);
        IButterflySpecies species = this.getGenome().getActiveValue(ButterflyChromosomes.SPECIES);
        return (species.getSpawnBiomes() == null || biome.m_203656_(species.getSpawnBiomes())) && this.isAcceptedEnvironment(level, pos);
    }

    @Override
    public boolean canTakeFlight(Level level, double x, double y, double z) {
        return this.canFly(level) && this.isAcceptedEnvironment(level, x, y, z);
    }

    private boolean canFly(Level world) {
        return (!world.m_46471_() || this.getGenome().getActiveValue(ButterflyChromosomes.TOLERATES_RAIN)) && this.isActiveThisTime(world.m_46461_());
    }

    @Override
    public boolean isAcceptedEnvironment(Level world, BlockPos pos) {
        Holder biome = world.m_204166_(pos);
        TemperatureType biomeTemperature = IForestryApi.INSTANCE.getClimateManager().getTemperature((Holder<Biome>)biome);
        HumidityType biomeHumidity = IForestryApi.INSTANCE.getClimateManager().getHumidity((Holder<Biome>)biome);
        return ClimateHelper.isWithinLimits(biomeTemperature, biomeHumidity, this.getGenome().getActiveValue(ButterflyChromosomes.SPECIES).getTemperature(), this.getGenome().getActiveValue(ButterflyChromosomes.TEMPERATURE_TOLERANCE), this.getGenome().getActiveValue(ButterflyChromosomes.SPECIES).getHumidity(), this.getGenome().getActiveValue(ButterflyChromosomes.HUMIDITY_TOLERANCE));
    }

    @Override
    @Nullable
    public IButterfly spawnCaterpillar(IButterflyNursery nursery) {
        if (this.mate == null) {
            return null;
        }
        SpeciesUtil.ISpeciesMutator mutator = (p1, p2) -> Butterfly.mutateSpecies(nursery, p1, p2);
        return SpeciesUtil.createOffspring(nursery.getWorldObj().f_46441_, this.genome, this.mate, mutator, Butterfly::new);
    }

    @Nullable
    private static ImmutableList<AllelePair<?>> mutateSpecies(IButterflyNursery nursery, IGenome parent1, IGenome parent2) {
        return SpeciesUtil.mutateSpecies(nursery.getWorldObj(), nursery.getCoordinates(), null, parent1, parent2, ButterflyChromosomes.SPECIES, Mutation::getChance);
    }

    private boolean isActiveThisTime(boolean isDayTime) {
        if (this.getGenome().getActiveValue(ButterflyChromosomes.NEVER_SLEEPS)) {
            return true;
        }
        return isDayTime != this.getGenome().getActiveValue(ButterflyChromosomes.SPECIES).isNocturnal();
    }

    @Override
    protected IIntegerChromosome getLifespanChromosome() {
        return ButterflyChromosomes.LIFESPAN;
    }

    @Override
    public List<ItemStack> getLootDrop(IEntityButterfly entity, boolean playerKill, int lootLevel) {
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        PathfinderMob creature = entity.getEntity();
        float metabolism = (float)this.getGenome().getActiveValue(ButterflyChromosomes.METABOLISM) / 10.0f;
        List<IProduct> products = ((IButterflySpecies)this.species).getButterflyLoot();
        RandomSource rand = creature.m_9236_().f_46441_;
        for (IProduct product : products) {
            if (!(rand.m_188501_() < product.chance() * metabolism)) continue;
            drop.add(product.createRandomStack(rand));
        }
        return drop;
    }

    @Override
    public List<ItemStack> getCaterpillarDrop(IButterflyNursery nursery, boolean playerKill, int lootLevel) {
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        float metabolism = (float)this.getGenome().getActiveValue(ButterflyChromosomes.METABOLISM) / 10.0f;
        List<IProduct> products = this.getGenome().getActiveValue(ButterflyChromosomes.SPECIES).getCaterpillarProducts();
        for (IProduct product : products) {
            if (!(rand.m_188501_() < product.chance() * metabolism)) continue;
            drop.add(product.createRandomStack(rand));
        }
        return drop;
    }

    @Override
    public List<ItemStack> getCocoonDrop(boolean includeButterfly, IButterflyCocoon cocoon) {
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        float metabolism = (float)this.getGenome().getActiveValue(ButterflyChromosomes.METABOLISM) / 10.0f;
        List<IProduct> products = cocoon.getProducts();
        for (IProduct product : products) {
            if (!(rand.m_188501_() < product.chance() * metabolism)) continue;
            drop.add(product.createRandomStack(rand));
        }
        IButterflySpeciesType butterflyType = (IButterflySpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get();
        if (ModuleLepidopterology.getSerumChance() > 0.0f && rand.m_188501_() < ModuleLepidopterology.getSerumChance() * metabolism) {
            ItemStack stack = butterflyType.createStack(this, (ILifeStage)ButterflyLifeStage.SERUM);
            if (ModuleLepidopterology.getSecondSerumChance() > 0.0f && rand.m_188501_() < ModuleLepidopterology.getSecondSerumChance() * metabolism) {
                stack.m_41764_(2);
            }
            drop.add(butterflyType.createStack(this, (ILifeStage)ButterflyLifeStage.SERUM));
        }
        if (includeButterfly) {
            drop.add(butterflyType.createStack(this, (ILifeStage)ButterflyLifeStage.BUTTERFLY));
        }
        return drop;
    }
}

