/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.carriers.players;

import forestry.api.mail.IMailAddress;
import forestry.mail.IWatchable;
import forestry.mail.MailAddress;
import forestry.mail.carriers.PostalCarriers;
import forestry.mail.carriers.players.POBox;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class POBoxRegistry
extends SavedData
implements IWatchable.Watcher {
    private static final String SAVE_NAME = "forestry_poboxes";
    public final Map<IMailAddress, POBox> cachedPOBoxes = new HashMap<IMailAddress, POBox>();

    public boolean isValidPOBox(IMailAddress address) {
        return address.getCarrier().equals(PostalCarriers.PLAYER.get()) && address.getName().matches("^[a-zA-Z0-9]+$");
    }

    private void registerPOBOx(IMailAddress address, POBox box) {
        this.cachedPOBoxes.put(address, box);
        box.registerUpdateWatcher(this);
        this.m_77762_();
    }

    public POBox getPOBox(IMailAddress address) {
        return this.cachedPOBoxes.get(address);
    }

    public POBox getOrCreatePOBox(IMailAddress address) {
        POBox pobox = this.getPOBox(address);
        if (pobox == null) {
            pobox = new POBox(address);
            this.registerPOBOx(address, pobox);
            pobox.setDirty();
        }
        return pobox;
    }

    @Override
    public void onWatchableUpdate() {
        this.m_77762_();
    }

    private static POBoxRegistry create() {
        return new POBoxRegistry();
    }

    private static POBoxRegistry load(CompoundTag compoundTag) {
        POBoxRegistry registry = new POBoxRegistry();
        ListTag tradeStations = compoundTag.m_128437_("poboxes", 10);
        for (int i = 0; i < tradeStations.size(); ++i) {
            CompoundTag stationTag = tradeStations.m_128728_(i);
            MailAddress address = new MailAddress(stationTag.m_128469_("address"));
            POBox pobox = new POBox(stationTag.m_128469_("pobox"));
            registry.registerPOBOx(address, pobox);
        }
        return registry;
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        ListTag poboxes = new ListTag();
        for (Map.Entry<IMailAddress, POBox> entry : this.cachedPOBoxes.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128365_("address", (Tag)entry.getKey().write(new CompoundTag()));
            entryTag.m_128365_("pobox", (Tag)entry.getValue().write(new CompoundTag()));
            poboxes.add((Object)entryTag);
        }
        compoundTag.m_128365_("poboxes", (Tag)poboxes);
        return compoundTag;
    }

    public static POBoxRegistry getOrCreate(ServerLevel level) {
        return (POBoxRegistry)level.m_8895_().m_164861_(POBoxRegistry::load, POBoxRegistry::create, SAVE_NAME);
    }
}

