/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.mail.ILetter;
import forestry.api.mail.IPostalState;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.tiles.TileBase;
import forestry.mail.LetterUtils;
import forestry.mail.MailAddress;
import forestry.mail.PostOffice;
import forestry.mail.carriers.players.POBoxRegistry;
import forestry.mail.features.MailTiles;
import forestry.mail.gui.ContainerMailbox;
import forestry.mail.postalstates.EnumDeliveryState;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class TileMailbox
extends TileBase {
    public TileMailbox(BlockPos pos, BlockState state) {
        super(MailTiles.MAILBOX.tileType(), pos, state);
        this.setInternalInventory(new InventoryAdapter(84, "Letters").disableAutomation());
    }

    @Override
    public void openGui(ServerPlayer player, InteractionHand hand, BlockPos pos) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        ItemStack heldItem = player.m_21120_(player.m_7655_());
        if (LetterUtils.isLetter(heldItem)) {
            IPostalState result = this.tryDispatchLetter(heldItem);
            if (!result.isOk()) {
                player.m_213846_(result.getDescription());
            } else {
                heldItem.m_41774_(1);
            }
        } else {
            super.openGui(player, hand, pos);
        }
    }

    public Container getOrCreateMailInventory(Level world, GameProfile playerProfile) {
        if (world.f_46443_) {
            return this.getInternalInventory();
        }
        MailAddress address = new MailAddress(playerProfile);
        return POBoxRegistry.getOrCreate((ServerLevel)world).getOrCreatePOBox(address);
    }

    private IPostalState tryDispatchLetter(ItemStack letterStack) {
        IPostalState result;
        ILetter letter = LetterUtils.getLetter(letterStack);
        if (letter != null) {
            ServerLevel world = (ServerLevel)this.f_58857_;
            result = PostOffice.getOrCreate(world).lodgeLetter(world, letterStack, true);
        } else {
            result = EnumDeliveryState.NOT_MAILABLE;
        }
        return result;
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ContainerMailbox(windowId, inv, this);
    }
}

