/*
 * Decompiled with CFR 0.152.
 */
package com.andcool;

import com.andcool.config.UserConfig;
import com.andcool.loader.Loader;
import com.andcool.rpManager.rpManager;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.Objects;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_442;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class MainClient
implements ClientModInitializer {
    public static String name = "PPL pack updater";
    public static final Logger LOGGER = LogManager.getLogger((String)name);
    public static Boolean yetAnotherConfigLibV3 = FabricLoader.getInstance().getModContainer("yet_another_config_lib_v3").isPresent();
    public static String titleScreenMessage = "";
    private static String message = "";
    private static int retries = 2;
    private static boolean working = false;
    private static boolean firstload = true;

    public static void betterLog(Level level, String message) {
        LOGGER.log(level, String.format("[%s]: %s", name, message));
    }

    public void onInitializeClient() {
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_442 && firstload) {
                firstload = false;
                UserConfig.load();
                if (UserConfig.ENABLE) {
                    MainClient.downloadPack();
                    ClientTickEvents.START_CLIENT_TICK.register(this::onClientStarted);
                }
            }
        });
    }

    public static void downloadPack() {
        retries = UserConfig.RETRIES;
        Thread downloadThread = new Thread(() -> {
            try {
                if (working) {
                    return;
                }
                working = true;
                titleScreenMessage = String.format("[%s] \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u0440\u0435\u0441\u0443\u0440\u0441\u043f\u0430\u043a\u0435...", name);
                JsonObject apiResponse = Loader.fetch();
                JsonObject packData = apiResponse.get(UserConfig.ONLY_EMOTES ? "emotes" : "main").getAsJsonObject();
                String version = packData.get("version").getAsString();
                String url = packData.get("url").getAsString();
                String originalChecksum = packData.get("checksum").getAsString();
                String date = packData.get("lastModified").getAsJsonObject().get("ru").getAsString();
                String filename = String.format("pepeland_%s_%s.zip", version, UserConfig.ONLY_EMOTES ? "emotes" : "main");
                boolean initiallyEnabled = rpManager.is_enabled();
                File file = new File("./resourcepacks/" + filename);
                if (version.equals(UserConfig.VERSION) && file.exists() && originalChecksum.equals(Loader.toSHA("./resourcepacks/" + filename))) {
                    MainClient.betterLog(Level.INFO, "Pack already up to date");
                    titleScreenMessage = "";
                    return;
                }
                while (retries + 1 > 0) {
                    MainClient.betterLog(Level.INFO, "Downloading resourcepack...");
                    if (retries == UserConfig.RETRIES) {
                        titleScreenMessage = String.format("[%s] \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u043f\u0430\u043a\u0430...", name);
                    }
                    Loader.download_file(url, "./resourcepacks/", filename);
                    String checksum = Loader.toSHA("./resourcepacks/" + filename);
                    if (originalChecksum.equals(checksum)) break;
                    MainClient.betterLog(Level.WARN, "Checksums didn't math! Retrying...");
                    if (--retries == 0) {
                        titleScreenMessage = String.format("[%s] \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043f\u0430\u043a (\u0444\u0430\u0439\u043b \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d)", name);
                        return;
                    }
                    titleScreenMessage = String.format("[%s] \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043f\u0430\u043a (\u0444\u0430\u0439\u043b \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d)\n\u041e\u0441\u0442\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043f\u044b\u0442\u043e\u043a: %s", name, retries);
                }
                if (initiallyEnabled || Objects.equals(UserConfig.VERSION, "null")) {
                    rpManager.disableAll();
                    rpManager.enable_resourcepack_and_reload(filename);
                }
                message = String.format("[%s] \u0420\u0435\u0441\u0443\u0440\u0441\u043f\u0430\u043a \u043e\u0431\u043d\u043e\u0432\u043b\u0451\u043d \u0434\u043e \u0432\u0435\u0440\u0441\u0438\u0438 %s (%s)", name, version, date);
                titleScreenMessage = "";
                UserConfig.VERSION = version;
                UserConfig.save();
            }
            catch (Exception e) {
                MainClient.betterLog(Level.ERROR, "Error:" + String.valueOf(e));
                titleScreenMessage = String.format("[%s] \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043a\u0430\u0447\u0430\u0442\u044c \u043f\u0430\u043a", name);
            }
            finally {
                working = false;
            }
        });
        downloadThread.start();
    }

    private void onClientStarted(class_310 client) {
        if (client.field_1687 != null && !message.isEmpty() && client.field_1705 != null) {
            client.field_1705.method_1743().method_1812(class_2561.method_30163((String)message));
            message = "";
        }
    }
}

