/*
 * Decompiled with CFR 0.152.
 */
package com.andcool.loader;

import com.andcool.MainClient;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3518;
import org.apache.logging.log4j.Level;

@Environment(value=EnvType.CLIENT)
public class Loader {
    public static void download_file(String fileURL, String saveDir, String filename) throws IOException {
        URL url = new URL(fileURL);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        int responseCode = httpConn.getResponseCode();
        String saveFilePath = saveDir + File.separator + filename;
        if (responseCode == 200) {
            int bytesRead;
            InputStream inputStream = httpConn.getInputStream();
            FileOutputStream outputStream = new FileOutputStream(saveFilePath);
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.close();
            inputStream.close();
            MainClient.betterLog(Level.DEBUG, "Resourcepack downloaded successfully.");
        } else {
            MainClient.betterLog(Level.ERROR, "No file to download. Server replied HTTP code: " + responseCode);
        }
        httpConn.disconnect();
    }

    public static JsonObject fetch() throws IOException, InterruptedException {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://static-api.pepeland.org/resourcepack/latest.json")).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        return class_3518.method_15285((String)response.body());
    }

    public static String toSHA(String filePath) throws NoSuchAlgorithmException, IOException {
        int bytesRead;
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        FileInputStream fis = new FileInputStream(filePath);
        byte[] buffer = new byte[1024];
        while ((bytesRead = fis.read(buffer)) != -1) {
            digest.update(buffer, 0, bytesRead);
        }
        fis.close();
        byte[] hashBytes = digest.digest();
        StringBuilder hexString = new StringBuilder();
        for (byte hashByte : hashBytes) {
            String hex = Integer.toHexString(0xFF & hashByte);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

