package com.messaging.client;

import com.messaging.client.gui.ContactListScreen;
import com.messaging.client.notification.NotificationManager;
import com.messaging.client.notification.NotificationRenderer;
import com.messaging.network.NetworkHandler;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.joml.Matrix3x2f;
import org.lwjgl.glfw.GLFW;

public class MessagingModClient implements ClientModInitializer {
    private static class_304 openMessagesKey;
    private static final NotificationRenderer notificationRenderer = new NotificationRenderer();

    @Override
    public void onInitializeClient() {
        com.messaging.config.ConfigManager.getInstance();
        // Register packet types (shared between client and server)
        NetworkHandler.registerPackets();

        // Register client-side packet receivers
        NetworkHandler.registerClientReceivers();

        // Register keybinding (default: M key)
        openMessagesKey = KeyBindingHelper.registerKeyBinding(new class_304(
                "key.messaging.open",
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_M,
                class_304.class_11900.field_62556
        ));

        // Register tick event to check for key press
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (openMessagesKey.method_1436()) {
                if (client.field_1724 != null) {
                    // Open contact list screen
                    client.method_1507(new ContactListScreen());
                }
            }

            // Tick notification manager
            NotificationManager.getInstance().tick(client);
        });

        // Register HUD rendering for notifications
        HudRenderCallback.EVENT.register((context, tickDelta) -> {
            Matrix3x2f matrix = new Matrix3x2f(context.method_51448());
            notificationRenderer.render(context,
                    (int) matrix.m20,
                    (int) matrix.m21 );
        });

        System.out.println("Messaging Mod (Client) initialized!");
    }

    public static NotificationRenderer getNotificationRenderer() {
        return notificationRenderer;
    }
}