package com.messaging.client.gui;

import com.messaging.network.MessageManager;
import java.util.*;
import java.util.stream.Collectors;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class ContactListScreen extends class_437 {
    private static final int CONTACT_HEIGHT = 60;
    private static final int PADDING = 10;
    private int scrollOffset = 0;
    private List<ContactEntry> contacts = new ArrayList<>();

    com.messaging.config.ConfigManager config = com.messaging.config.ConfigManager.getInstance();
    com.messaging.config.ConfigManager.Theme theme = config.getTheme();

    public ContactListScreen() {
        super(class_2561.method_43470("Messages"));
    }

    @Override
    protected void method_25426() {
        MessageManager.getInstance().requestPlayerList();
        loadContacts();
        super.method_25426();

        // Close button
        this.method_37063(class_4185.method_46430(
                class_2561.method_43470("✕"),
                button -> this.method_25419()
        ).method_46434(this.field_22789 - 30, 5, 20, 20).method_46431());

        // Refresh button
        this.method_37063(class_4185.method_46430(
                class_2561.method_43470("↻"),
                button -> {
                    loadContacts();
                }
        ).method_46434(this.field_22789 - 55, 5, 20, 20).method_46431());

        this.method_37063(class_4185.method_46430(
                class_2561.method_43470("⚙"),
                button -> {
                    if (this.field_22787 != null) {
                        this.field_22787.method_1507(new com.messaging.client.gui.SettingsScreen(this));
                    }
                }
        ).method_46434(this.field_22789 - 80, 5, 20, 20).method_46431());

    }

    private void loadContacts() {
        contacts.clear();
        MessageManager manager = MessageManager.getInstance();

        // Get current player name to exclude self
        String selfName = null;
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            selfName = client.field_1724.method_5477().getString().toLowerCase();
        }

        // Get all unique contacts (people we've messaged or who are online)
        Set<String> allContactNames = new HashSet<>();

        // Add people we have message history with
        Set<String> historyContacts = manager.getAllContacts();

        for (String contact : historyContacts) {
            if (selfName == null || !contact.equalsIgnoreCase(selfName)) {
                allContactNames.add(contact);
            }
        }

        // Add online players (excluding self)
        Set<String> onlinePlayers = manager.getOnlinePlayers();
        for (String player : onlinePlayers) {
            if (selfName == null || !player.equalsIgnoreCase(selfName)) {
                allContactNames.add(player);
            }
        }


        for (String contact : allContactNames) {
            List<MessageManager.ChatMessage> messages = manager.getMessages(contact);
            boolean isOnline = manager.isPlayerOnline(contact);

            String lastMessage = "";
            long lastTimestamp = 0;
            int unreadCount = 0; // TODO: Implement unread tracking

            if (!messages.isEmpty()) {
                MessageManager.ChatMessage last = messages.get(messages.size() - 1);
                lastMessage = last.content;
                lastTimestamp = last.timestamp;
            }

            contacts.add(new ContactEntry(contact, lastMessage, lastTimestamp, isOnline, unreadCount));
        }

        // Sort by most recent message first, then by online status
        contacts.sort((a, b) -> {
            // If one has messages and the other doesn't, prioritize the one with messages
            if (a.lastTimestamp > 0 && b.lastTimestamp == 0) return -1;
            if (b.lastTimestamp > 0 && a.lastTimestamp == 0) return 1;

            // If both have messages, sort by timestamp
            if (a.lastTimestamp > 0 && b.lastTimestamp > 0) {
                return Long.compare(b.lastTimestamp, a.lastTimestamp);
            }

            // If neither has messages, sort by online status then name
            if (a.isOnline != b.isOnline) {
                return a.isOnline ? -1 : 1;
            }
            return a.name.compareToIgnoreCase(b.name);
        });
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        MessageManager.getInstance().requestPlayerList();
        loadContacts();

        // Reload contacts each frame to ensure online status is current
        super.method_25394(context, mouseX, mouseY, delta);

        // Background
        context.method_25294(0, 0, this.field_22789, this.field_22790, theme.primaryBg);

        // Header
        this.renderHeader(context);

        // Contacts list
        this.renderContacts(context, mouseX, mouseY);
        int darkTextColor = 0xFF000000;
        int lightTextColor = 0xFFFFFFFF;
        int textColor = lightTextColor;
        String name = theme.name;
        if (name == "Light") {
            textColor = darkTextColor;
        }
        else if (name == "Dark") {
            textColor = lightTextColor;
        }
        context.method_51433(this.field_22793, "↻",field_22789 - 55,  5, textColor, false);
        context.method_51433(this.field_22793, "✕",field_22789 - 30,  5, textColor, false);
        context.method_51433(this.field_22793, "⚙",field_22789 - 80,  5, textColor, false);

        // Render widgets
    }

    private void renderHeader(class_332 context) {
        int darkTextColor = 0xFF000000;
        int lightTextColor = 0xFFFFFFFF;
        int textColor = lightTextColor;
        class_124 formattingColor = class_124.field_1068;
        class_124 formattingBold = class_124.field_1067;
        String name = theme.name;
        if (name == "Light") {
            textColor = darkTextColor;
            formattingColor = class_124.field_1074;
            formattingBold = null;

        }
        else if (name == "Dark") {
            textColor = lightTextColor;
            formattingColor = class_124.field_1068;
            formattingBold = class_124.field_1067;
        }
        int headerHeight = 50;
        context.method_25294(0, 0, this.field_22789, headerHeight, theme.secondaryBg);

        // Title
        class_2561 title = class_2561.method_43470("Messages").method_27692(formattingColor);
        int titleX = PADDING;
        context.method_51439(this.field_22793, title, titleX, 15, textColor, false);

        // Subtitle
        class_2561 subtitle = class_2561.method_43470(contacts.size() + " conversation" + (contacts.size() != 1 ? "s" : ""))
                .method_27692(class_124.field_1080);
        context.method_51439(this.field_22793, subtitle, titleX, 30, textColor, false);
    }

    private void renderContacts(class_332 context, int mouseX, int mouseY) {
        int headerHeight = 50;
        int startY = headerHeight + PADDING;
        int endY = this.field_22790;

        context.method_44379(0, startY, this.field_22789, endY);

        int currentY = startY - scrollOffset;

        for (ContactEntry contact : contacts) {
            if (currentY + CONTACT_HEIGHT >= startY && currentY <= endY) {
                boolean hovered = mouseX >= PADDING && mouseX <= this.field_22789 - PADDING &&
                        mouseY >= currentY && mouseY <= currentY + CONTACT_HEIGHT;

                this.renderContact(context, contact, currentY, hovered);
            }
            currentY += CONTACT_HEIGHT + 5;
        }

        context.method_44380();

        // No contacts message
        if (contacts.isEmpty()) {
            class_2561 noContacts = class_2561.method_43470("No messages yet").method_27692(class_124.field_1080);
            int x = (this.field_22789 - this.field_22793.method_27525(noContacts)) / 2;
            int y = (this.field_22790 - 50) / 2;
            context.method_51439(this.field_22793, noContacts, x, y, 0xFF888888, false);

            class_2561 hint = class_2561.method_43470("Start a conversation by messaging an online player").method_27692(class_124.field_1063);
            int hintX = (this.field_22789 - this.field_22793.method_27525(hint)) / 2;
            context.method_51439(this.field_22793, hint, hintX, y + 15, 0xFF555555, false);
        }
    }

    private void renderContact(class_332 context, ContactEntry contact, int y, boolean hovered) {
        int darkTextColor = 0xFF000000;
        int lightTextColor = 0xFFFFFFFF;
        int textColor = lightTextColor;
        class_124 formattingColor = class_124.field_1068;
        class_124 formattingBold = class_124.field_1067;
        String name = theme.name;
        if (name == "Light") {
            textColor = darkTextColor;
            formattingColor = class_124.field_1074;
            formattingBold = null;
            class_2561 title = class_2561.method_43470("Messages").method_27692(formattingColor);

        }
        else if (name == "Dark") {
            textColor = lightTextColor;
            formattingColor = class_124.field_1068;
            formattingBold = class_124.field_1067;
        }
        int bgColor = hovered ? theme.primaryBg : theme.secondaryBg;
        context.method_25294(PADDING, y, this.field_22789 - PADDING, y + CONTACT_HEIGHT, bgColor);

        // Contact name
        class_2561 nameText = class_2561.method_43470(contact.name).method_27692(formattingColor);
        context.method_51439(this.field_22793, nameText, PADDING + 10, y + 10, textColor, false);

        // Online status
        if (contact.isOnline) {
            context.method_25294(this.field_22789 - PADDING - 20, y + 12, this.field_22789 - PADDING - 14, y + 18, 0xFF00FF00);
            class_2561 onlineText = class_2561.method_43470("Online").method_27692(class_124.field_1060);
            context.method_51439(this.field_22793, onlineText, this.field_22789 - PADDING - 60, y + 10, 0xFF00FF00, false);
        } else {
            class_2561 offlineText = class_2561.method_43470("Offline").method_27692(class_124.field_1080);
            context.method_51439(this.field_22793, offlineText, this.field_22789 - PADDING - 60, y + 10, 0xFF888888, false);
        }

        // Last message preview
        if (!contact.lastMessage.isEmpty()) {
            String preview = contact.lastMessage;
            if (preview.length() > 50) {
                preview = preview.substring(0, 47) + "...";
            }
            class_2561 previewText = class_2561.method_43470(preview).method_27692(class_124.field_1080);
            context.method_51439(this.field_22793, previewText, PADDING + 10, y + 28, 0xFF888888, false);
        }

        // Timestamp
        if (contact.lastTimestamp > 0) {
            String timeStr = formatTimestamp(contact.lastTimestamp);
            class_2561 timeText = class_2561.method_43470(timeStr).method_27692(class_124.field_1063);
            int timeX = this.field_22789 - PADDING - 10 - this.field_22793.method_27525(timeText);
            context.method_51439(this.field_22793, timeText, timeX, y + 45, 0xFF555555, false);
        }

        // Unread badge
        if (contact.unreadCount > 0) {
            int badgeSize = 20;
            int badgeX = this.field_22789 - PADDING - 30;
            int badgeY = y + 40;

            context.method_25294(badgeX, badgeY, badgeX + badgeSize, badgeY + badgeSize, 0xFF007AFF);

            String count = String.valueOf(contact.unreadCount);
            class_2561 countText = class_2561.method_43470(count);
            int countX = badgeX + (badgeSize - this.field_22793.method_27525(countText)) / 2;
            int countY = badgeY + (badgeSize - 8) / 2;
            context.method_51439(this.field_22793, countText, countX, countY, 0xFFFFFFFF, false);
        }

        // Divider line
        context.method_25294(PADDING + 10, y + CONTACT_HEIGHT + 4, this.field_22789 - PADDING - 10, y + CONTACT_HEIGHT + 5, 0xFF333333);
    }

    private String formatTimestamp(long timestamp) {
        long diff = System.currentTimeMillis() - timestamp;
        long seconds = diff / 1000;
        long minutes = seconds / 60;
        long hours = minutes / 60;
        long days = hours / 24;

        if (days > 0) {
            return days + "d ago";
        } else if (hours > 0) {
            return hours + "h ago";
        } else if (minutes > 0) {
            return minutes + "m ago";
        } else {
            return "Just now";
        }
    }

    @Override
    public boolean method_25402(class_11909 click, boolean doubleClick) {
        int headerHeight = 50;
        int startY = headerHeight + PADDING;
        int currentY = startY - scrollOffset;

        for (ContactEntry contact : contacts) {
            if (click.comp_4798() >= PADDING && click.comp_4798() <= this.field_22789 - PADDING &&
                    click.comp_4799() >= currentY && click.comp_4799() <= currentY + CONTACT_HEIGHT) {

                // Open message screen with this contact
                if (this.field_22787 != null) {
                    this.field_22787.method_1507(new MessageScreen(contact.name));
                }
                return true;
            }
            currentY += CONTACT_HEIGHT + 5;
        }

        return super.method_25402(click, doubleClick);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int maxScroll = Math.max(0, contacts.size() * (CONTACT_HEIGHT + 5) - (this.field_22790 - 60));
        scrollOffset -= (int) (verticalAmount * 20);
        scrollOffset = Math.max(0, Math.min(scrollOffset, maxScroll));
        return true;
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    private static class ContactEntry {
        String name;
        String lastMessage;
        long lastTimestamp;
        boolean isOnline;
        int unreadCount;

        ContactEntry(String name, String lastMessage, long lastTimestamp, boolean isOnline, int unreadCount) {
            this.name = name;
            this.lastMessage = lastMessage;
            this.lastTimestamp = lastTimestamp;
            this.isOnline = isOnline;
            this.unreadCount = unreadCount;
        }
    }
}