package com.messaging.client.gui;

import com.messaging.config.ConfigManager;
import com.messaging.network.MessageManager;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;


public class MessageScreen extends class_437 {
    private class_342 messageInput;
    private List<MessageManager.ChatMessage> messages = new ArrayList<>();
    private String recipientName;
    private int scrollOffset = 0;
    private static final int PADDING = 10;
    private static final int MESSAGE_SPACING = 8;
    private static final int BUBBLE_PADDING = 8;
    private MessageManager messageManager;
    private int lastMessageCount = 0;
    private int totalContentHeight = 0;
    ConfigManager config = ConfigManager.getInstance();
    ConfigManager.Theme theme = config.getTheme();

    public MessageScreen(String recipientName) {
        super(class_2561.method_43470("Messages"));
        this.recipientName = recipientName;
        this.messageManager = MessageManager.getInstance();

        // Load message history
        this.messages = messageManager.getMessages(recipientName);
        this.lastMessageCount = messages.size();

        // Request history from server
        messageManager.requestHistory(recipientName);
    }

    public String getRecipientName() {
        return recipientName;
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        // Message input field at the bottom
        int inputHeight = 30;
        int inputY = this.field_22790 - inputHeight - PADDING;

        this.messageInput = new class_342(
                this.field_22793,
                PADDING + 5,
                inputY + 5,
                this.field_22789 - 80 - PADDING,
                20,
                class_2561.method_43470("Message")
        );
        this.messageInput.method_1880(256);
        this.messageInput.method_47404(class_2561.method_43470("Enter Text...").method_27692(class_124.field_1080));
        this.method_25429(this.messageInput);
        this.method_48265(this.messageInput);

        // Send button
        this.method_37063(class_4185.method_46430(
                class_2561.method_43470("Send"),
                button -> this.sendMessage()
        ).method_46434(this.field_22789 - 70, inputY + 10, 60, 20).method_46431());

        // Back button (top left)
        this.method_37063(class_4185.method_46430(
                class_2561.method_43470("←"),
                button -> {
                    if (this.field_22787 != null) {
                        this.field_22787.method_1507(new ContactListScreen());
                    }
                }
        ).method_46434(5, 5, 20, 20).method_46431());

        // Close button (top right)
        this.method_37063(class_4185.method_46430(
                class_2561.method_43470("✕"),
                button -> this.method_25419()
        ).method_46434(this.field_22789 - 30, 5, 20, 20).method_46431());
    }

    private void sendMessage() {
        String message = this.messageInput.method_1882().trim();
        if (!message.isEmpty()) {
            messageManager.sendMessage(recipientName, message);
            messages = messageManager.getMessages(recipientName);
            this.messageInput.method_1852("");

            // Auto-scroll to bottom when sending
            scrollOffset = 0;
        }
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        // Refresh messages in case we received new ones
        List<MessageManager.ChatMessage> currentMessages = messageManager.getMessages(recipientName);

        // Check if we got new messages and auto-scroll to bottom
        if (currentMessages.size() != lastMessageCount) {
            messages = currentMessages;
            lastMessageCount = messages.size();
            scrollOffset = 0; // Auto-scroll to bottom on new messages
        } else {
            messages = currentMessages;
        }
        // Render widgets (buttons and text field)
        super.method_25394(context, mouseX, mouseY, delta);
        // Background
        context.method_25294(0, 0, this.field_22789, this.field_22790, theme.primaryBg);

        // Header bar
        this.renderHeader(context);

        // Messages area
        this.renderMessages(context);

        // Input area background
        int inputY = this.field_22790 - 40;
        context.method_25294(PADDING, inputY, this.field_22789 - PADDING, this.field_22790 - PADDING, theme.secondaryBg);


        // Render text field text on top
        int darkTextColor = 0xFF000000;
        int lightTextColor = 0xFFFFFFFF;
        int textColor = lightTextColor;
        String name = theme.name;
        if (name == "Light") {
            textColor = darkTextColor;
        }
        else if (name == "Dark") {
            textColor = lightTextColor;
        }
        this.messageInput.method_25394(context, mouseX, mouseY, delta);
        context.method_51433(this.field_22793, "✕",field_22789 - 30,  5, textColor, false);
        context.method_51433(this.field_22793, "Send", field_22789 - 70, inputY + 10, textColor, false);
        context.method_51433(this.field_22793, "←", 5, 5, textColor, false);
    }

    private void renderHeader(class_332 context) {
        int headerHeight = 50;
        context.method_25294(0, 0, this.field_22789, headerHeight, theme.secondaryBg);

        // Recipient name
        int darkTextColor = 0xFF000000;
        int lightTextColor = 0xFFFFFFFF;
        int textColor = lightTextColor;
        class_124 formattingColor = class_124.field_1068;
        String name = theme.name;
        if (name == "Light") {
            textColor = darkTextColor;
            formattingColor = class_124.field_1074;
        }
        else if (name == "Dark") {
            textColor = lightTextColor;
            formattingColor = class_124.field_1068;
        }
        class_2561 nameText = class_2561.method_43470(recipientName).method_27692(formattingColor);
        int nameX = (this.field_22789 - this.field_22793.method_27525(nameText)) / 2;
        context.method_51439(this.field_22793, nameText, nameX, 15, textColor, false);

        // Status (online/offline)
        boolean isOnline = messageManager.isPlayerOnline(recipientName);
        class_2561 statusText = isOnline ?
                class_2561.method_43470("● Online").method_27692(class_124.field_1060) :
                class_2561.method_43470("● Offline").method_27692(class_124.field_1080);
        int statusColor = isOnline ? 0xFF00FF00 : 0xFF888888;
        int statusX = (this.field_22789 - this.field_22793.method_27525(statusText)) / 2;
        context.method_51439(this.field_22793, statusText, statusX, 30, statusColor, false);
    }

    private void renderMessages(class_332 context) {
        int headerHeight = 50;
        int inputAreaHeight = 50;
        int messagesAreaTop = headerHeight + PADDING;
        int messagesAreaBottom = this.field_22790 - inputAreaHeight - PADDING;
        int messagesAreaHeight = messagesAreaBottom - messagesAreaTop;

        // Calculate total content height for scrolling
        totalContentHeight = 0;
        for (MessageManager.ChatMessage msg : messages) {
            List<String> wrappedLines = this.wrapText(msg.content, this.field_22789 - 120);
            int bubbleHeight = wrappedLines.size() * 10 + BUBBLE_PADDING * 2;
            totalContentHeight += bubbleHeight + MESSAGE_SPACING;
        }

        // Enable scissor for scrolling
        context.method_44379(0, messagesAreaTop, this.field_22789, messagesAreaBottom);

        // Start from top if content fits, otherwise from bottom with scroll offset
        int startY;
        if (totalContentHeight <= messagesAreaHeight) {
            // Content fits - render from top
            startY = messagesAreaTop + PADDING;
        } else {
            // Content doesn't fit - render from bottom with scroll
            startY = messagesAreaBottom - totalContentHeight + scrollOffset;
        }

        int currentY = startY;

        // Render messages from top to bottom (oldest to newest)
        for (int i = 0; i < messages.size(); i++) {
            MessageManager.ChatMessage msg = messages.get(i);
            currentY = this.renderMessage(context, msg, currentY);
            currentY += MESSAGE_SPACING;
        }

        context.method_44380();

        // No messages indicator
        if (messages.isEmpty()) {
            class_2561 noMessages = class_2561.method_43470("No messages yet").method_27692(class_124.field_1080);
            int x = (this.field_22789 - this.field_22793.method_27525(noMessages)) / 2;
            int y = (messagesAreaTop + messagesAreaBottom) / 2;
            context.method_51439(this.field_22793, noMessages, x, y, 0xFF888888, false);
        }
    }

    private int renderMessage(class_332 context, MessageManager.ChatMessage message, int topY) {
        List<String> wrappedLines = this.wrapText(message.content, this.field_22789 - 120);
        int bubbleHeight = wrappedLines.size() * 10 + BUBBLE_PADDING * 2;

        int maxBubbleWidth = this.field_22789 - 100;
        int bubbleWidth = Math.min(maxBubbleWidth, this.calculateTextWidth(wrappedLines) + BUBBLE_PADDING * 2);

        int bubbleX;
        int bubbleColor;
        int textColor;

        if (message.isSentByPlayer) {
            // Sent messages (right side, blue)
            bubbleX = this.field_22789 - bubbleWidth - PADDING * 2;
            bubbleColor = config.getSentBubbleColor(); // iMessage blue
            textColor = 0xFFFFFFFF;
        } else {
            // Received messages (left side, gray)
            bubbleX = PADDING * 2;
            bubbleColor = config.getReceivedBubbleColor(); // Dark gray
            textColor = 0xFFFFFFFF;
        }

        int darkTextColor = 0xFF000000;
        int lightTextColor = 0xFFFFFFFF;
        int textColors = lightTextColor;
        String name = theme.name;
        if (name == "Light") {
            textColors = darkTextColor;
        }
        else if (name == "Dark") {
            textColors = lightTextColor;
        }

        // Draw rounded bubble (approximated with multiple fills)
        this.drawRoundedRect(context, bubbleX, topY, bubbleWidth, bubbleHeight, bubbleColor);

        // Draw text
        int textY = topY + BUBBLE_PADDING;
        for (String line : wrappedLines) {
            context.method_51433(this.field_22793, line, bubbleX + BUBBLE_PADDING, textY, textColors, false);
            textY += 10;
        }

        return topY + bubbleHeight;
    }

    private void drawRoundedRect(class_332 context, int x, int y, int width, int height, int color) {
        // Simple rounded corners approximation
        int radius = 4;

        // Main body
        context.method_25294(x + radius, y, x + width - radius, y + height, color);
        context.method_25294(x, y + radius, x + width, y + height - radius, color);

        // Corners (simple approximation)
        context.method_25294(x + 1, y + 1, x + radius, y + radius, color);
        context.method_25294(x + width - radius, y + 1, x + width - 1, y + radius, color);
        context.method_25294(x + 1, y + height - radius, x + radius, y + height - 1, color);
        context.method_25294(x + width - radius, y + height - radius, x + width - 1, y + height - 1, color);
    }

    private List<String> wrapText(String text, int maxWidth) {
        List<String> lines = new ArrayList<>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();

        for (String word : words) {
            String testLine = currentLine.length() == 0 ? word : currentLine + " " + word;
            if (this.field_22793.method_1727(testLine) <= maxWidth) {
                if (currentLine.length() > 0) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
            } else {
                if (currentLine.length() > 0) {
                    lines.add(currentLine.toString());
                }
                currentLine = new StringBuilder(word);
            }
        }

        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }

        return lines.isEmpty() ? List.of(text) : lines;
    }

    private int calculateTextWidth(List<String> lines) {
        int maxWidth = 0;
        for (String line : lines) {
            maxWidth = Math.max(maxWidth, this.field_22793.method_1727(line));
        }
        return maxWidth;
    }

    @Override
    public boolean method_25404(class_11908 keyInput) {
        if (keyInput.method_74230() || keyInput.comp_4795() == 335) { // Enter or Numpad Enter
            this.sendMessage();
            return true;
        }
        return super.method_25404(keyInput);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int headerHeight = 50;
        int inputAreaHeight = 50;
        int messagesAreaHeight = this.field_22790 - headerHeight - inputAreaHeight - PADDING * 2;

        // Only allow scrolling if content is taller than the viewable area
        if (totalContentHeight > messagesAreaHeight) {
            // Scroll up = positive verticalAmount = increase scrollOffset (show older messages)
            // Scroll down = negative verticalAmount = decrease scrollOffset (show newer messages)
            scrollOffset += (int) (verticalAmount * 20);

            // Limit scroll range
            int maxScroll = totalContentHeight - messagesAreaHeight;
            scrollOffset = Math.max(0, Math.min(scrollOffset, maxScroll));
        }

        return true;
    }

    @Override
    public boolean method_25421() {
        return false;
    }
}