package com.messaging.client.gui;

import com.messaging.config.ConfigManager;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5676;

public class SettingsScreen extends class_437 {
    private final class_437 parent;
    private ConfigManager configManager;

    public SettingsScreen(class_437 parent) {
        super(class_2561.method_43470("Messaging Settings"));
        this.parent = parent;
        this.configManager = ConfigManager.getInstance();
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        int centerX = this.field_22789 / 2;
        int startY = 60;
        int buttonWidth = 300;
        int buttonHeight = 20;
        int spacing = 40;

        // Server Logging Toggle
        this.method_37063(class_5676.method_32607(
                        class_2561.method_43470("ON").method_27692(class_124.field_1060),
                        class_2561.method_43470("OFF").method_27692(class_124.field_1061)
                ).method_32619(configManager.allowServerLogging())
                .method_32617(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight,
                        class_2561.method_43470("Allow Server Logging"),
                        (button, value) -> configManager.setAllowServerLogging(value)
                ));

        // Notification Sound Toggle
        this.method_37063(class_5676.method_32607(
                        class_2561.method_43470("ON").method_27692(class_124.field_1060),
                        class_2561.method_43470("OFF").method_27692(class_124.field_1061)
                ).method_32619(configManager.playNotificationSound())
                .method_32617(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight,
                        class_2561.method_43470("Notification Sound"),
                        (button, value) -> configManager.setPlayNotificationSound(value)
                ));

        // Show Notifications Toggle
        this.method_37063(class_5676.method_32607(
                        class_2561.method_43470("ON").method_27692(class_124.field_1060),
                        class_2561.method_43470("OFF").method_27692(class_124.field_1061)
                ).method_32619(configManager.showNotifications())
                .method_32617(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight,
                        class_2561.method_43470("Show Notifications"),
                        (button, value) -> configManager.setShowNotifications(value)
                ));
        this.method_37063(class_4185.method_46430(
                class_2561.method_43470("Theme & Colors"),
                button -> {
                    if (this.field_22787 != null) {
                        this.field_22787.method_1507(new ThemeCustomizationScreen(this));
                    }
                }
        ).method_46434(centerX - buttonWidth / 2, startY + spacing * 3 + 10, buttonWidth, buttonHeight).method_46431());

        // Done button
        this.method_37063(class_4185.method_46430(
                class_2561.method_43470("Done"),
                button -> this.method_25419()
        ).method_46434(centerX - 100, this.field_22790 - 30, 200, 20).method_46431());
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        // Background
        super.method_25394(context, mouseX, mouseY, delta);
        // Title
        class_2561 title = class_2561.method_43470("Messaging Settings").method_27695(class_124.field_1068, class_124.field_1067);
        context.method_27534(this.field_22793, title, this.field_22789 / 2, 20, 0xFFFFFFFF);

        // Descriptions
        int descY = 85;
        int spacing = 30;

        context.method_27534(this.field_22793,
                class_2561.method_43470("When OFF, server won't log your messages to console").method_27692(class_124.field_1080),
                this.field_22789 / 2, descY - 35, 0xFF888888);

        context.method_27534(this.field_22793,
                class_2561.method_43470("Play a sound when receiving messages").method_27692(class_124.field_1080),
                this.field_22789 / 2, descY - 25 + spacing, 0xFF888888);

        context.method_27534(this.field_22793,
                class_2561.method_43470("Show notification pop-ups for new messages").method_27692(class_124.field_1080),
                this.field_22789 / 2, descY - 17 + spacing * 2, 0xFF888888);


    }


    @Override
    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(parent);
        }
    }

    @Override
    public boolean method_25421() {
        return true;
    }
}