package com.messaging.client.gui;

import com.messaging.config.ConfigManager;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class ThemeCustomizationScreen extends class_437 {
    private final class_437 parent;
    private ConfigManager configManager;

    private static final int[][] PRESET_COLORS = {
            {0xFF007AFF, 0xFF3A3A3C}, // iMessage (Blue/Gray)
            {0xFF34B7F1, 0xFF2C2C2E}, // Twitter Blue
            {0xFF25D366, 0xFF1F1F1F}, // WhatsApp Green
            {0xFF7289DA, 0xFF2C2F33}, // Discord Blurple
            {0xFFE01E5A, 0xFF1A1D21}, // Slack Magenta
            {0xFFFF6B6B, 0xFF4A4A4A}, // Red
            {0xFFFFD93D, 0xFF3A3A3A}, // Yellow
            {0xFF6BCF7F, 0xFF2F2F2F}, // Green
            {0xFFAD5EFF, 0xFF2B2B2B}, // Purple
            {0xFFFF6B9D, 0xFF353535}, // Pink
    };

    private static final String[] PRESET_NAMES = {
            "iMessage", "Twitter", "WhatsApp", "Discord", "Slack",
            "Red", "Yellow", "Green", "Purple", "Pink"
    };

    private int previewTab = 0; // 0 = Messages, 1 = Contacts

    public ThemeCustomizationScreen(class_437 parent) {
        super(class_2561.method_43470("Theme & Colors"));
        this.parent = parent;
        this.configManager = ConfigManager.getInstance();
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        int centerX = this.field_22789 / 2;
        int leftPanelX = 20;
        int buttonWidth = 150;
        int buttonHeight = 20;
        int startY = 40;

        // Theme selection buttons
        int themeY = startY;
        for (ConfigManager.Theme theme : ConfigManager.Theme.values()) {
            this.method_37063(class_4185.method_46430(
                    class_2561.method_43470(theme.name),
                    button -> {
                        configManager.setTheme(theme);
                    }
            ).method_46434(leftPanelX, themeY, buttonWidth, buttonHeight).method_46431());
            themeY += 25;
        }

        // Color preset buttons
        int presetStartY = themeY + 20;
        int presetX = leftPanelX;
        int presetY = presetStartY;
        int presetSize = 30;
        int presetSpacing = 35;

        for (int i = 0; i < PRESET_COLORS.length; i++) {
            final int index = i;
            int buttonX = presetX + (i % 5) * presetSpacing;
            int buttonY = presetY + (i / 5) * presetSpacing;

            this.method_37063(new ColorPresetButton(
                    buttonX, buttonY, presetSize, presetSize,
                    PRESET_COLORS[index][0], PRESET_COLORS[index][1],
                    PRESET_NAMES[index],
                    button -> {
                        configManager.setSentBubbleColor(PRESET_COLORS[index][0]);
                        configManager.setReceivedBubbleColor(PRESET_COLORS[index][1]);
                    }
            ));
        }

        // Preview tab buttons
        int previewButtonY = startY;
        this.method_37063(class_4185.method_46430(
                class_2561.method_43470("Messages Preview"),
                button -> previewTab = 0
        ).method_46434(this.field_22789 - 230, previewButtonY, 110, buttonHeight).method_46431());

        this.method_37063(class_4185.method_46430(
                class_2561.method_43470("Contacts Preview"),
                button -> previewTab = 1
        ).method_46434(this.field_22789 - 115, previewButtonY, 110, buttonHeight).method_46431());

        // Done button
        this.method_37063(class_4185.method_46430(
                class_2561.method_43470("Done"),
                button -> this.method_25419()
        ).method_46434((this.field_22789 / 2) + 140, 10, 100, 20).method_46431());
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        ConfigManager.Theme theme = configManager.getTheme();
        int darkTextColor = 0xFF000000;
        int lightTextColor = 0xFFFFFFFF;
        int textColor = lightTextColor;
        class_124 formattingColor = class_124.field_1068;
        String name = theme.name;
        if (name == "Light") {
            textColor = darkTextColor;
            formattingColor = class_124.field_1074;
        }
        else if (name == "Dark") {
            textColor = lightTextColor;
            formattingColor = class_124.field_1068;
        }

        // Background
        context.method_25294(0, 0, this.field_22789, this.field_22790, theme.primaryBg);

        // Title
        class_2561 title = class_2561.method_43470("Theme & Color Customization").method_27692(formattingColor);
        context.method_51439(this.field_22793, title, (this.field_22789 / 2) - 20, 10, textColor, false);

        // Left panel background
        context.method_25294(10, 15, 190, this.field_22790 - 20, theme.primaryBg);
        super.method_25394(context, mouseX, mouseY, delta);

        // Section labels
        context.method_51439(this.field_22793, class_2561.method_43470("Themes"), 20, 25, textColor, false);

        int presetLabelY = 40 + (ConfigManager.Theme.values().length * 25) + 5;
        context.method_51439(this.field_22793, class_2561.method_43470("Text Bubble Presets"), 20, presetLabelY, textColor, false);

        // Preview panel
        renderPreview(context, theme);

    }

    private void renderPreview(class_332 context, ConfigManager.Theme theme) {
        int darkTextColor = 0xFF000000;
        int lightTextColor = 0xFFFFFFFF;
        int textColor = lightTextColor;
        class_124 formattingColor = class_124.field_1068;
        String name = theme.name;
        if (name == "Light") {
            textColor = darkTextColor;
            formattingColor = class_124.field_1074;
        }
        else if (name == "Dark") {
            textColor = lightTextColor;
            formattingColor = class_124.field_1068;
        }
        int previewX = 200;
        int previewY = 70;
        int previewWidth = this.field_22789 - previewX - 10;
        int previewHeight = this.field_22790 - previewY - 50;

        // Preview background
        context.method_25294(previewX, previewY, previewX + previewWidth, previewY + previewHeight + 35, theme.tertiaryBg);

        if (previewTab == 0) {
            renderMessagesPreview(context, previewX, previewY, previewWidth, previewHeight, theme);
        } else {
            renderContactsPreview(context, previewX, previewY, previewWidth, previewHeight, theme);
        }

        // Preview label
        context.method_51439(this.field_22793,
                class_2561.method_43470("Preview").method_27695(),
                previewX + 5, previewY - 15, textColor, false);
    }

    private void renderMessagesPreview(class_332 context, int x, int y, int width, int height, ConfigManager.Theme theme) {
        // Header
        int darkTextColor = 0xFF000000;
        int lightTextColor = 0xFFFFFFFF;
        int textColor = lightTextColor;
        class_124 formattingColor = class_124.field_1068;
        String name = theme.name;
        if (name == "Light") {
            textColor = darkTextColor;
            formattingColor = class_124.field_1074;
        }
        else if (name == "Dark") {
            textColor = lightTextColor;
            formattingColor = class_124.field_1068;
        }
        int headerHeight = 40;
        int contactY = y + headerHeight + 10;
        context.method_25294(x, y, x + width, y + headerHeight, theme.secondaryBg);
        context.method_51439(this.field_22793,
                class_2561.method_43470("Preview User").method_27692(class_124.field_1067),
                x + width / 2, y + 10, textColor, false);
        context.method_51439(this.field_22793,
                class_2561.method_43470("● Online").method_27692(class_124.field_1060),
                x + width / 2 - 40, y + 10, 0xFF00FF00, false);

        // Messages area
        int msgY = y + headerHeight + 10;

        // Received message
        int receivedBubbleWidth = 200;
        int receivedBubbleHeight = 30;
        drawRoundedRect(context, x + 10, msgY, receivedBubbleWidth, receivedBubbleHeight,
                configManager.getReceivedBubbleColor());
        context.method_51433(this.field_22793, "Hey! How are you?", x + 18, msgY + 10, 0xFFFFFFFF, false);

        // Sent message
        msgY += 40;
        int sentBubbleWidth = 180;
        int sentBubbleHeight = 30;
        drawRoundedRect(context, x + width - sentBubbleWidth - 10, msgY, sentBubbleWidth, sentBubbleHeight,
                configManager.getSentBubbleColor());
        context.method_51433(this.field_22793, "I'm doing great!", x + width - sentBubbleWidth - 2, msgY + 10, 0xFFFFFFFF, false);

        // Input area
        int inputY = y + height - 35;
        context.method_25294(x + 5, inputY + 40, x + width - 5, inputY + 67, theme.secondaryBg);
        context.method_51439(this.field_22793,
                class_2561.method_43470("Enter Text...").method_27692(class_124.field_1080),
                x + 10, inputY + 50, 0xFF888888, false);
    }

    private void renderContactsPreview(class_332 context, int x, int y, int width, int height, ConfigManager.Theme theme) {
        // Header
        int darkTextColor = 0xFF000000;
        int lightTextColor = 0xFFFFFFFF;
        int textColor = lightTextColor;
        class_124 formattingColor = class_124.field_1068;
        String name = theme.name;
        if (name == "Light") {
            textColor = darkTextColor;
            formattingColor = class_124.field_1074;
        }
        else if (name == "Dark") {
            textColor = lightTextColor;
            formattingColor = class_124.field_1068;
        }
        int headerHeight = 40;
        context.method_25294(x, y, x + width, y + headerHeight, theme.primaryBg);
        context.method_51439(this.field_22793,
                class_2561.method_43470("Messages"),
                x + 10, y + 10, textColor, false);
        context.method_51439(this.field_22793,
                class_2561.method_43470("2 conversations").method_27692(class_124.field_1080),
                x + 10, y + 25, 0xFF888888, false);

        // Contact entries
        int contactY = y + headerHeight + 10;
        int contactHeight = 50;

        // Contact 1
        context.method_25294(x + 10, contactY, x + width - 10, contactY + contactHeight, theme.primaryBg);
        context.method_51439(this.field_22793,
                class_2561.method_43470("Steve").method_27695(),
                x + 15, contactY + 8, textColor, false);
        context.method_25294(x + width - 25, contactY + 10, x + width - 19, contactY + 16, 0xFF00FF00);
        context.method_51439(this.field_22793,
                class_2561.method_43470("See you later!").method_27692(class_124.field_1080),
                x + 15, contactY + 23, 0xFF888888, false);
        context.method_51439(this.field_22793,
                class_2561.method_43470("Online").method_27692(class_124.field_1060),
                x + 215, contactY + 10, 0xFF00FF00, false);
        context.method_51439(this.field_22793,
                class_2561.method_43470("2m ago").method_27692(class_124.field_1063),
                x + width - 60, contactY + 38, 0xFF555555, false);

        // Contact 2
        contactY += contactHeight + 5;

        context.method_25294(x + 10, contactY, x + width - 10, contactY + contactHeight, theme.primaryBg);
        context.method_51439(this.field_22793,
                class_2561.method_43470("Bob"),
                x + 15, contactY + 8, textColor, false);
        context.method_51439(this.field_22793,
                class_2561.method_43470("Offline").method_27692(class_124.field_1080),
                x + width - 60, contactY + 8, 0xFF888888, false);
        context.method_51439(this.field_22793,
                class_2561.method_43470("Thanks for the help").method_27692(class_124.field_1080),
                x + 15, contactY + 23, 0xFF888888, false);
        context.method_51439(this.field_22793,
                class_2561.method_43470("1h ago").method_27692(class_124.field_1063),
                x + width - 60, contactY + 38, 0xFF555555, false);
    }

    private void drawRoundedRect(class_332 context, int x, int y, int width, int height, int color) {
        int radius = 4;
        context.method_25294(x + radius, y, x + width - radius, y + height, color);
        context.method_25294(x, y + radius, x + width, y + height - radius, color);
        context.method_25294(x + 1, y + 1, x + radius, y + radius, color);
        context.method_25294(x + width - radius, y + 1, x + width - 1, y + radius, color);
        context.method_25294(x + 1, y + height - radius, x + radius, y + height - 1, color);
        context.method_25294(x + width - radius, y + height - radius, x + width - 1, y + height - 1, color);
    }

    @Override
    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(parent);
        }
    }

    @Override
    public boolean method_25421() {
        return true;
    }

    // Custom button for color presets
    private class ColorPresetButton extends class_4185 {
        private final int sentColor;
        private final int receivedColor;
        private final String presetName;

        public ColorPresetButton(int x, int y, int width, int height, int sentColor, int receivedColor, String presetName, class_4241 onPress) {
            super(x, y, width, height, class_2561.method_43473(), onPress, field_40754);
            this.sentColor = sentColor;
            this.receivedColor = receivedColor;
            this.presetName = presetName;
        }

        @Override
        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            // Border if hovered
            if (this.method_49606()) {
                context.method_25294(this.method_46426() - 2, this.method_46427() - 2, this.method_46426() + this.field_22758 + 2, this.method_46427() + this.field_22759 + 2, 0xFFFFFFFF);
            }

            // Split button in half
            context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758 / 2, this.method_46427() + this.field_22759, sentColor);
            context.method_25294(this.method_46426() + this.field_22758 / 2, this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, receivedColor);

            // Tooltip on hover
            if (this.method_49606() && field_22787 != null) {
                context.method_51438(field_22787.field_1772, class_2561.method_43470(presetName), mouseX, mouseY);
            }
        }
    }
}