package com.messaging.client.notification;

import com.messaging.client.gui.MessageScreen;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1109;
import net.minecraft.class_310;
import net.minecraft.class_3417;

public class NotificationManager {
    private static NotificationManager instance;
    private final List<MessageNotification> notifications = new ArrayList<>();
    private static final int MAX_NOTIFICATIONS = 3;
    private static final long NOTIFICATION_DURATION = 5000; // 5 seconds

    private NotificationManager() {}

    public static NotificationManager getInstance() {
        if (instance == null) {
            instance = new NotificationManager();
        }
        return instance;
    }

    public void showNotification(String senderName, String message) {
        // Check if notifications are enabled in config
        if (!com.messaging.config.ConfigManager.getInstance().showNotifications()) {
            return;
        }

        // Don't show notification if already on message screen with this person
        class_310 client = class_310.method_1551();
        if (client.field_1755 instanceof MessageScreen) {
            MessageScreen screen = (MessageScreen) client.field_1755;
            if (screen.getRecipientName().equalsIgnoreCase(senderName)) {
                return; // Already viewing this conversation
            }
        }

        // Remove oldest notification if at max
        if (notifications.size() >= MAX_NOTIFICATIONS) {
            notifications.remove(0);
        }

        // Add new notification
        MessageNotification notification = new MessageNotification(
                senderName,
                message,
                System.currentTimeMillis()
        );
        notifications.add(notification);

        // Play notification sound if enabled
        if (com.messaging.config.ConfigManager.getInstance().playNotificationSound() && client.field_1724 != null) {
            client.method_1483().method_4873(
                    class_1109.method_4758(class_3417.field_14627, 1.0f)
            );
        }
    }

    public void tick(class_310 client) {
        long currentTime = System.currentTimeMillis();
        Iterator<MessageNotification> iterator = notifications.iterator();

        while (iterator.hasNext()) {
            MessageNotification notification = iterator.next();
            if (currentTime - notification.timestamp > NOTIFICATION_DURATION) {
                iterator.remove();
            }
        }
    }

    public List<MessageNotification> getNotifications() {
        return new ArrayList<>(notifications);
    }

    public void removeNotification(MessageNotification notification) {
        notifications.remove(notification);
    }

    public void openNotification(MessageNotification notification) {
        class_310 client = class_310.method_1551();
        client.method_1507(new MessageScreen(notification.senderName));
        removeNotification(notification);
    }

    public static class MessageNotification {
        public final String senderName;
        public final String message;
        public final long timestamp;

        public MessageNotification(String senderName, String message, long timestamp) {
            this.senderName = senderName;
            this.message = message;
            this.timestamp = timestamp;
        }

        public float getAlpha() {
            long age = System.currentTimeMillis() - timestamp;
            if (age < 300) {
                // Fade in
                return age / 300f;
            } else if (age > NOTIFICATION_DURATION - 500) {
                // Fade out
                return (NOTIFICATION_DURATION - age) / 500f;
            }
            return 1.0f;
        }
    }
}