/*
 * Decompiled with CFR 0.152.
 */
package com.messaging.client.gui;

import com.messaging.config.ConfigManager;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ThemeCustomizationScreen
extends class_437 {
    private final class_437 parent;
    private ConfigManager configManager;
    private static final int[][] PRESET_COLORS = new int[][]{{-16745729, -12961220}, {-13322255, -13882322}, {-14298266, -14737633}, {-9270822, -13881549}, {-2089382, -15065823}, {-38037, -11908534}, {-9923, -12961222}, {-9711745, -13684945}, {-5415169, -13948117}, {-37987, -13290187}};
    private static final String[] PRESET_NAMES = new String[]{"iMessage", "Twitter", "WhatsApp", "Discord", "Slack", "Red", "Yellow", "Green", "Purple", "Pink"};
    private int previewTab = 0;

    public ThemeCustomizationScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Theme & Colors"));
        this.parent = parent;
        this.configManager = ConfigManager.getInstance();
    }

    protected void method_25426() {
        int startY;
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int leftPanelX = 20;
        int buttonWidth = 150;
        int buttonHeight = 20;
        int themeY = startY = 40;
        for (ConfigManager.Theme theme : ConfigManager.Theme.values()) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)theme.name), button -> this.configManager.setTheme(theme)).method_46434(leftPanelX, themeY, buttonWidth, buttonHeight).method_46431());
            themeY += 25;
        }
        int presetStartY = themeY + 20;
        int presetX = leftPanelX;
        int presetY = presetStartY;
        int presetSize = 30;
        int presetSpacing = 35;
        for (int i = 0; i < PRESET_COLORS.length; ++i) {
            int index = i;
            int buttonX = presetX + i % 5 * presetSpacing;
            int buttonY = presetY + i / 5 * presetSpacing;
            this.method_37063((class_364)new ColorPresetButton(buttonX, buttonY, presetSize, presetSize, PRESET_COLORS[index][0], PRESET_COLORS[index][1], PRESET_NAMES[index], button -> {
                this.configManager.setSentBubbleColor(PRESET_COLORS[index][0]);
                this.configManager.setReceivedBubbleColor(PRESET_COLORS[index][1]);
            }));
        }
        int previewButtonY = startY;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Messages Preview"), button -> {
            this.previewTab = 0;
        }).method_46434(this.field_22789 - 230, previewButtonY, 110, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Contacts Preview"), button -> {
            this.previewTab = 1;
        }).method_46434(this.field_22789 - 115, previewButtonY, 110, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), button -> this.method_25419()).method_46434(this.field_22789 / 2 + 140, 10, 100, 20).method_46431());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int lightTextColor;
        ConfigManager.Theme theme = this.configManager.getTheme();
        int darkTextColor = -16777216;
        int textColor = lightTextColor = -1;
        class_124 formattingColor = class_124.field_1068;
        String name = theme.name;
        if (name == "Light") {
            textColor = darkTextColor;
            formattingColor = class_124.field_1074;
        } else if (name == "Dark") {
            textColor = lightTextColor;
            formattingColor = class_124.field_1068;
        }
        context.method_25294(0, 0, this.field_22789, this.field_22790, theme.primaryBg);
        class_5250 title = class_2561.method_43470((String)"Theme & Color Customization").method_27692(formattingColor);
        context.method_51439(this.field_22793, (class_2561)title, this.field_22789 / 2 - 20, 10, textColor, false);
        context.method_25294(10, 15, 190, this.field_22790 - 20, theme.primaryBg);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Themes"), 20, 25, textColor, false);
        int presetLabelY = 40 + ConfigManager.Theme.values().length * 25 + 5;
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Text Bubble Presets"), 20, presetLabelY, textColor, false);
        this.renderPreview(context, theme);
    }

    private void renderPreview(class_332 context, ConfigManager.Theme theme) {
        int lightTextColor;
        int darkTextColor = -16777216;
        int textColor = lightTextColor = -1;
        class_124 formattingColor = class_124.field_1068;
        String name = theme.name;
        if (name == "Light") {
            textColor = darkTextColor;
            formattingColor = class_124.field_1074;
        } else if (name == "Dark") {
            textColor = lightTextColor;
            formattingColor = class_124.field_1068;
        }
        int previewX = 200;
        int previewY = 70;
        int previewWidth = this.field_22789 - previewX - 10;
        int previewHeight = this.field_22790 - previewY - 50;
        context.method_25294(previewX, previewY, previewX + previewWidth, previewY + previewHeight + 35, theme.tertiaryBg);
        if (this.previewTab == 0) {
            this.renderMessagesPreview(context, previewX, previewY, previewWidth, previewHeight, theme);
        } else {
            this.renderContactsPreview(context, previewX, previewY, previewWidth, previewHeight, theme);
        }
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Preview").method_27695(new class_124[0]), previewX + 5, previewY - 15, textColor, false);
    }

    private void renderMessagesPreview(class_332 context, int x, int y, int width, int height, ConfigManager.Theme theme) {
        int lightTextColor;
        int darkTextColor = -16777216;
        int textColor = lightTextColor = -1;
        class_124 formattingColor = class_124.field_1068;
        String name = theme.name;
        if (name == "Light") {
            textColor = darkTextColor;
            formattingColor = class_124.field_1074;
        } else if (name == "Dark") {
            textColor = lightTextColor;
            formattingColor = class_124.field_1068;
        }
        int headerHeight = 40;
        int contactY = y + headerHeight + 10;
        context.method_25294(x, y, x + width, y + headerHeight, theme.secondaryBg);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Preview User").method_27692(class_124.field_1067), x + width / 2, y + 10, textColor, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"\u25cf Online").method_27692(class_124.field_1060), x + width / 2 - 40, y + 10, -16711936, false);
        int msgY = y + headerHeight + 10;
        int receivedBubbleWidth = 200;
        int receivedBubbleHeight = 30;
        this.drawRoundedRect(context, x + 10, msgY, receivedBubbleWidth, receivedBubbleHeight, this.configManager.getReceivedBubbleColor());
        context.method_51433(this.field_22793, "Hey! How are you?", x + 18, msgY + 10, -1, false);
        int sentBubbleWidth = 180;
        int sentBubbleHeight = 30;
        this.drawRoundedRect(context, x + width - sentBubbleWidth - 10, msgY += 40, sentBubbleWidth, sentBubbleHeight, this.configManager.getSentBubbleColor());
        context.method_51433(this.field_22793, "I'm doing great!", x + width - sentBubbleWidth - 2, msgY + 10, -1, false);
        int inputY = y + height - 35;
        context.method_25294(x + 5, inputY + 40, x + width - 5, inputY + 67, theme.secondaryBg);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Enter Text...").method_27692(class_124.field_1080), x + 10, inputY + 50, -7829368, false);
    }

    private void renderContactsPreview(class_332 context, int x, int y, int width, int height, ConfigManager.Theme theme) {
        int lightTextColor;
        int darkTextColor = -16777216;
        int textColor = lightTextColor = -1;
        class_124 formattingColor = class_124.field_1068;
        String name = theme.name;
        if (name == "Light") {
            textColor = darkTextColor;
            formattingColor = class_124.field_1074;
        } else if (name == "Dark") {
            textColor = lightTextColor;
            formattingColor = class_124.field_1068;
        }
        int headerHeight = 40;
        context.method_25294(x, y, x + width, y + headerHeight, theme.primaryBg);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Messages"), x + 10, y + 10, textColor, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"2 conversations").method_27692(class_124.field_1080), x + 10, y + 25, -7829368, false);
        int contactY = y + headerHeight + 10;
        int contactHeight = 50;
        context.method_25294(x + 10, contactY, x + width - 10, contactY + contactHeight, theme.primaryBg);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Steve").method_27695(new class_124[0]), x + 15, contactY + 8, textColor, false);
        context.method_25294(x + width - 25, contactY + 10, x + width - 19, contactY + 16, -16711936);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"See you later!").method_27692(class_124.field_1080), x + 15, contactY + 23, -7829368, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Online").method_27692(class_124.field_1060), x + 215, contactY + 10, -16711936, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"2m ago").method_27692(class_124.field_1063), x + width - 60, contactY + 38, -11184811, false);
        context.method_25294(x + 10, contactY += contactHeight + 5, x + width - 10, contactY + contactHeight, theme.primaryBg);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Bob"), x + 15, contactY + 8, textColor, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Offline").method_27692(class_124.field_1080), x + width - 60, contactY + 8, -7829368, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Thanks for the help").method_27692(class_124.field_1080), x + 15, contactY + 23, -7829368, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"1h ago").method_27692(class_124.field_1063), x + width - 60, contactY + 38, -11184811, false);
    }

    private void drawRoundedRect(class_332 context, int x, int y, int width, int height, int color) {
        int radius = 4;
        context.method_25294(x + radius, y, x + width - radius, y + height, color);
        context.method_25294(x, y + radius, x + width, y + height - radius, color);
        context.method_25294(x + 1, y + 1, x + radius, y + radius, color);
        context.method_25294(x + width - radius, y + 1, x + width - 1, y + radius, color);
        context.method_25294(x + 1, y + height - radius, x + radius, y + height - 1, color);
        context.method_25294(x + width - radius, y + height - radius, x + width - 1, y + height - 1, color);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public boolean method_25421() {
        return true;
    }

    private class ColorPresetButton
    extends class_4185 {
        private final int sentColor;
        private final int receivedColor;
        private final String presetName;

        public ColorPresetButton(int x, int y, int width, int height, int sentColor, int receivedColor, String presetName, class_4185.class_4241 onPress) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), onPress, field_40754);
            this.sentColor = sentColor;
            this.receivedColor = receivedColor;
            this.presetName = presetName;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            if (this.method_49606()) {
                context.method_25294(this.method_46426() - 2, this.method_46427() - 2, this.method_46426() + this.field_22758 + 2, this.method_46427() + this.field_22759 + 2, -1);
            }
            context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758 / 2, this.method_46427() + this.field_22759, this.sentColor);
            context.method_25294(this.method_46426() + this.field_22758 / 2, this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, this.receivedColor);
            if (this.method_49606() && ThemeCustomizationScreen.this.field_22787 != null) {
                context.method_51438(((ThemeCustomizationScreen)ThemeCustomizationScreen.this).field_22787.field_1772, (class_2561)class_2561.method_43470((String)this.presetName), mouseX, mouseY);
            }
        }
    }
}

