/*
 * Decompiled with CFR 0.152.
 */
package com.messaging.network;

import com.messaging.client.notification.NotificationManager;
import com.messaging.network.MessageManager;
import com.messaging.server.ServerMessageHandler;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class NetworkHandler {
    public static final class_2960 SEND_MESSAGE_ID = class_2960.method_60655((String)"messaging-mod", (String)"send_message");
    public static final class_2960 RECEIVE_MESSAGE_ID = class_2960.method_60655((String)"messaging-mod", (String)"receive_message");
    public static final class_2960 REQUEST_HISTORY_ID = class_2960.method_60655((String)"messaging-mod", (String)"request_history");
    public static final class_2960 SYNC_HISTORY_ID = class_2960.method_60655((String)"messaging-mod", (String)"sync_history");
    public static final class_2960 PLAYER_LIST_ID = class_2960.method_60655((String)"messaging-mod", (String)"player_list");
    public static final class_2960 REQUEST_PLAYER_LIST_ID = class_2960.method_60655((String)"messaging-mod", (String)"request_player_list");
    private static boolean packetsRegistered = false;

    public static void registerPackets() {
        if (packetsRegistered) {
            return;
        }
        packetsRegistered = true;
        PayloadTypeRegistry.playC2S().register(SendMessagePayload.ID, SendMessagePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(RequestHistoryPayload.ID, RequestHistoryPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(RequestPlayerListPayload.ID, RequestPlayerListPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(ReceiveMessagePayload.ID, ReceiveMessagePayload.CODEC);
        PayloadTypeRegistry.playS2C().register(SyncHistoryPayload.ID, SyncHistoryPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(PlayerListPayload.ID, PlayerListPayload.CODEC);
    }

    public static void registerClientReceivers() {
        ClientPlayNetworking.registerGlobalReceiver(ReceiveMessagePayload.ID, (payload, context) -> context.client().execute(() -> {
            MessageManager.getInstance().addMessage(payload.sender(), payload.message(), false, payload.timestamp());
            NotificationManager.getInstance().showNotification(payload.sender(), payload.message());
        }));
        ClientPlayNetworking.registerGlobalReceiver(SyncHistoryPayload.ID, (payload, context) -> context.client().execute(() -> MessageManager.getInstance().loadHistoryFromServer(payload.recipient(), payload.messages())));
        ClientPlayNetworking.registerGlobalReceiver(PlayerListPayload.ID, (payload, context) -> context.client().execute(() -> MessageManager.getInstance().updateOnlinePlayers(payload.players())));
    }

    public static void registerServerReceivers() {
        ServerPlayNetworking.registerGlobalReceiver(SendMessagePayload.ID, (payload, context) -> context.server().execute(() -> ServerMessageHandler.handleSendMessage(context.player(), payload.recipient(), payload.message(), payload.allowLogging())));
        ServerPlayNetworking.registerGlobalReceiver(RequestHistoryPayload.ID, (payload, context) -> context.server().execute(() -> ServerMessageHandler.handleHistoryRequest(context.player(), payload.otherPlayer())));
        ServerPlayNetworking.registerGlobalReceiver(RequestPlayerListPayload.ID, (payload, context) -> context.server().execute(() -> ServerMessageHandler.handlePlayerListRequest(context.player())));
    }

    public record SendMessagePayload(String recipient, String message, boolean allowLogging) implements class_8710
    {
        public static final class_8710.class_9154<SendMessagePayload> ID = new class_8710.class_9154(SEND_MESSAGE_ID);
        public static final class_9139<class_9129, SendMessagePayload> CODEC = class_9139.method_56436((class_9139)class_9135.field_48554, SendMessagePayload::recipient, (class_9139)class_9135.field_48554, SendMessagePayload::message, (class_9139)class_9135.field_48547, SendMessagePayload::allowLogging, SendMessagePayload::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public record RequestHistoryPayload(String otherPlayer) implements class_8710
    {
        public static final class_8710.class_9154<RequestHistoryPayload> ID = new class_8710.class_9154(REQUEST_HISTORY_ID);
        public static final class_9139<class_9129, RequestHistoryPayload> CODEC = class_9139.method_56434((class_9139)class_9135.field_48554, RequestHistoryPayload::otherPlayer, RequestHistoryPayload::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public record RequestPlayerListPayload() implements class_8710
    {
        public static final class_8710.class_9154<RequestPlayerListPayload> ID = new class_8710.class_9154(REQUEST_PLAYER_LIST_ID);
        public static final class_9139<class_9129, RequestPlayerListPayload> CODEC = class_9139.method_56431((Object)new RequestPlayerListPayload());

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public record ReceiveMessagePayload(String sender, String message, long timestamp) implements class_8710
    {
        public static final class_8710.class_9154<ReceiveMessagePayload> ID = new class_8710.class_9154(RECEIVE_MESSAGE_ID);
        public static final class_9139<class_9129, ReceiveMessagePayload> CODEC = class_9139.method_56436((class_9139)class_9135.field_48554, ReceiveMessagePayload::sender, (class_9139)class_9135.field_48554, ReceiveMessagePayload::message, (class_9139)class_9135.field_48551, ReceiveMessagePayload::timestamp, ReceiveMessagePayload::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public record SyncHistoryPayload(String recipient, String messages) implements class_8710
    {
        public static final class_8710.class_9154<SyncHistoryPayload> ID = new class_8710.class_9154(SYNC_HISTORY_ID);
        public static final class_9139<class_9129, SyncHistoryPayload> CODEC = class_9139.method_56435((class_9139)class_9135.field_48554, SyncHistoryPayload::recipient, (class_9139)class_9135.field_48554, SyncHistoryPayload::messages, SyncHistoryPayload::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public record PlayerListPayload(String players) implements class_8710
    {
        public static final class_8710.class_9154<PlayerListPayload> ID = new class_8710.class_9154(PLAYER_LIST_ID);
        public static final class_9139<class_9129, PlayerListPayload> CODEC = class_9139.method_56434((class_9139)class_9135.field_48554, PlayerListPayload::players, PlayerListPayload::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }
}

