/*
 * Decompiled with CFR 0.152.
 */
package com.messaging.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.messaging.network.NetworkHandler;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class ServerMessageHandler {
    private static final Map<String, List<StoredMessage>> serverMessageHistory = new ConcurrentHashMap<String, List<StoredMessage>>();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static Path serverStoragePath;

    public static void initialize(Path worldPath) {
        try {
            serverStoragePath = worldPath.resolve("messaging-mod");
            Files.createDirectories(serverStoragePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to create server messaging storage: " + e.getMessage());
        }
    }

    public static void handleSendMessage(class_3222 sender, String recipientName, String message, boolean allowLogging) {
        String senderName = sender.method_5477().getString();
        long timestamp = System.currentTimeMillis();
        if (allowLogging) {
            System.out.println("[Messaging] " + senderName + " -> " + recipientName + ": " + message);
        }
        ServerMessageHandler.storeMessage(senderName, recipientName, message, timestamp);
        class_3222 recipient = sender.method_51469().method_8503().method_3760().method_14566(recipientName);
        if (recipient != null) {
            if (allowLogging) {
                System.out.println("[Messaging] Sending message to online recipient: " + recipientName);
            }
            ServerPlayNetworking.send((class_3222)recipient, (class_8710)new NetworkHandler.ReceiveMessagePayload(senderName, message, timestamp));
        } else if (allowLogging) {
            System.out.println("[Messaging] Recipient offline, message stored: " + recipientName);
        }
        ServerMessageHandler.broadcastPlayerList(sender.method_51469().method_8503().method_3760().method_14571());
    }

    public static void handleHistoryRequest(class_3222 requester, String otherPlayer) {
        String requesterName = requester.method_5477().getString();
        List<StoredMessage> messages = ServerMessageHandler.loadConversation(requesterName, otherPlayer);
        ArrayList<ClientMessage> clientMessages = new ArrayList<ClientMessage>();
        for (StoredMessage msg : messages) {
            boolean sentByPlayer = msg.sender.equals(requesterName);
            clientMessages.add(new ClientMessage(msg.message, sentByPlayer, msg.timestamp));
        }
        String messagesJson = gson.toJson(clientMessages);
        ServerPlayNetworking.send((class_3222)requester, (class_8710)new NetworkHandler.SyncHistoryPayload(otherPlayer, messagesJson));
    }

    public static void handlePlayerListRequest(class_3222 requester) {
        List players = requester.method_51469().method_8503().method_3760().method_14571();
        ArrayList<String> playerNames = new ArrayList<String>();
        for (class_3222 player : players) {
            playerNames.add(player.method_5477().getString());
        }
        String playersJson = gson.toJson(playerNames);
        ServerPlayNetworking.send((class_3222)requester, (class_8710)new NetworkHandler.PlayerListPayload(playersJson));
    }

    public static void broadcastPlayerList(List<class_3222> players) {
        ArrayList<String> playerNames = new ArrayList<String>();
        for (class_3222 player : players) {
            playerNames.add(player.method_5477().getString());
        }
        String playersJson = gson.toJson(playerNames);
        NetworkHandler.PlayerListPayload payload = new NetworkHandler.PlayerListPayload(playersJson);
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        }
    }

    private static void storeMessage(String sender, String recipient, String message, long timestamp) {
        String conversationKey = ServerMessageHandler.getConversationKey(sender, recipient);
        List messages = serverMessageHistory.computeIfAbsent(conversationKey, k -> ServerMessageHandler.loadMessagesFromFile(conversationKey));
        messages.add(new StoredMessage(sender, recipient, message, timestamp));
        ServerMessageHandler.saveMessagesToFile(conversationKey, messages);
    }

    private static List<StoredMessage> loadConversation(String player1, String player2) {
        String conversationKey = ServerMessageHandler.getConversationKey(player1, player2);
        if (!serverMessageHistory.containsKey(conversationKey)) {
            serverMessageHistory.put(conversationKey, ServerMessageHandler.loadMessagesFromFile(conversationKey));
        }
        return new ArrayList<StoredMessage>((Collection)serverMessageHistory.get(conversationKey));
    }

    private static String getConversationKey(String player1, String player2) {
        List<String> names = Arrays.asList(player1.toLowerCase(), player2.toLowerCase());
        Collections.sort(names);
        return names.get(0) + "_" + names.get(1);
    }

    private static List<StoredMessage> loadMessagesFromFile(String conversationKey) {
        block8: {
            List list;
            if (serverStoragePath == null) {
                return new ArrayList<StoredMessage>();
            }
            File file = serverStoragePath.resolve(conversationKey + ".json").toFile();
            if (!file.exists()) break block8;
            FileReader reader = new FileReader(file);
            try {
                List messages = (List)gson.fromJson((Reader)reader, new TypeToken<List<StoredMessage>>(){}.getType());
                list = messages != null ? messages : new ArrayList();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    System.err.println("Failed to load conversation " + conversationKey + ": " + e.getMessage());
                }
            }
            reader.close();
            return list;
        }
        return new ArrayList<StoredMessage>();
    }

    private static void saveMessagesToFile(String conversationKey, List<StoredMessage> messages) {
        if (serverStoragePath == null) {
            return;
        }
        try {
            File file = serverStoragePath.resolve(conversationKey + ".json").toFile();
            try (FileWriter writer = new FileWriter(file);){
                gson.toJson(messages, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save conversation " + conversationKey + ": " + e.getMessage());
        }
    }

    private static class StoredMessage {
        String sender;
        String recipient;
        String message;
        long timestamp;

        StoredMessage(String sender, String recipient, String message, long timestamp) {
            this.sender = sender;
            this.recipient = recipient;
            this.message = message;
            this.timestamp = timestamp;
        }
    }

    private static class ClientMessage {
        String content;
        boolean isSentByPlayer;
        long timestamp;

        ClientMessage(String content, boolean isSentByPlayer, long timestamp) {
            this.content = content;
            this.isSentByPlayer = isSentByPlayer;
            this.timestamp = timestamp;
        }
    }
}

