/*
 * Decompiled with CFR 0.152.
 */
package com.messaging.client.notification;

import com.messaging.client.gui.MessageScreen;
import com.messaging.config.ConfigManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_437;

public class NotificationManager {
    private static NotificationManager instance;
    private final List<MessageNotification> notifications = new ArrayList<MessageNotification>();
    private static final int MAX_NOTIFICATIONS = 3;
    private static final long NOTIFICATION_DURATION = 5000L;

    private NotificationManager() {
    }

    public static NotificationManager getInstance() {
        if (instance == null) {
            instance = new NotificationManager();
        }
        return instance;
    }

    public void showNotification(String senderName, String message) {
        MessageScreen screen;
        if (!ConfigManager.getInstance().showNotifications()) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1755 instanceof MessageScreen && (screen = (MessageScreen)client.field_1755).getRecipientName().equalsIgnoreCase(senderName)) {
            return;
        }
        if (this.notifications.size() >= 3) {
            this.notifications.remove(0);
        }
        MessageNotification notification = new MessageNotification(senderName, message, System.currentTimeMillis());
        this.notifications.add(notification);
        if (ConfigManager.getInstance().playNotificationSound() && client.field_1724 != null) {
            client.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14627, (float)1.0f));
        }
    }

    public void tick(class_310 client) {
        long currentTime = System.currentTimeMillis();
        Iterator<MessageNotification> iterator = this.notifications.iterator();
        while (iterator.hasNext()) {
            MessageNotification notification = iterator.next();
            if (currentTime - notification.timestamp <= 5000L) continue;
            iterator.remove();
        }
    }

    public List<MessageNotification> getNotifications() {
        return new ArrayList<MessageNotification>(this.notifications);
    }

    public void removeNotification(MessageNotification notification) {
        this.notifications.remove(notification);
    }

    public void openNotification(MessageNotification notification) {
        class_310 client = class_310.method_1551();
        client.method_1507((class_437)new MessageScreen(notification.senderName));
        this.removeNotification(notification);
    }

    public static class MessageNotification {
        public final String senderName;
        public final String message;
        public final long timestamp;

        public MessageNotification(String senderName, String message, long timestamp) {
            this.senderName = senderName;
            this.message = message;
            this.timestamp = timestamp;
        }

        public float getAlpha() {
            long age = System.currentTimeMillis() - this.timestamp;
            if (age < 300L) {
                return (float)age / 300.0f;
            }
            if (age > 4500L) {
                return (float)(5000L - age) / 500.0f;
            }
            return 1.0f;
        }
    }
}

