/*
 * Decompiled with CFR 0.152.
 */
package com.messaging.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_310;

public class ConfigManager {
    private static ConfigManager instance;
    private Config config;
    private Path configPath;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    private ConfigManager() {
        this.loadConfig();
    }

    public static ConfigManager getInstance() {
        if (instance == null) {
            instance = new ConfigManager();
        }
        return instance;
    }

    private void loadConfig() {
        block9: {
            try {
                class_310 client = class_310.method_1551();
                if (client.field_1697 != null) {
                    this.configPath = client.field_1697.toPath().resolve("config").resolve("messaging-mod.json");
                    Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
                    if (Files.exists(this.configPath, new LinkOption[0])) {
                        try (FileReader reader = new FileReader(this.configPath.toFile());){
                            this.config = (Config)this.gson.fromJson((Reader)reader, Config.class);
                            break block9;
                        }
                    }
                    this.config = new Config();
                    this.saveConfig();
                    break block9;
                }
                this.config = new Config();
            }
            catch (IOException e) {
                System.err.println("Failed to load config: " + e.getMessage());
                this.config = new Config();
            }
        }
    }

    public void saveConfig() {
        if (this.configPath == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(this.configPath.toFile());){
            this.gson.toJson((Object)this.config, (Appendable)writer);
            writer.flush();
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public boolean allowServerLogging() {
        return this.config.allowServerLogging;
    }

    public void setAllowServerLogging(boolean allow) {
        this.config.allowServerLogging = allow;
        this.saveConfig();
    }

    public boolean playNotificationSound() {
        return this.config.playNotificationSound;
    }

    public void setPlayNotificationSound(boolean play) {
        this.config.playNotificationSound = play;
        this.saveConfig();
    }

    public boolean showNotifications() {
        return this.config.showNotifications;
    }

    public void setShowNotifications(boolean show) {
        this.config.showNotifications = show;
        this.saveConfig();
    }

    public Theme getTheme() {
        return this.config.theme;
    }

    public void setTheme(Theme theme) {
        this.config.theme = theme;
        this.saveConfig();
    }

    public int getSentBubbleColor() {
        return this.config.sentBubbleColor;
    }

    public void setSentBubbleColor(int color) {
        this.config.sentBubbleColor = color;
        this.saveConfig();
    }

    public int getReceivedBubbleColor() {
        return this.config.receivedBubbleColor;
    }

    public void setReceivedBubbleColor(int color) {
        this.config.receivedBubbleColor = color;
        this.saveConfig();
    }

    public static class Config {
        public boolean allowServerLogging = true;
        public boolean playNotificationSound = true;
        public boolean showNotifications = true;
        public Theme theme = Theme.DARK;
        public int sentBubbleColor = -16745729;
        public int receivedBubbleColor = -12961220;
        public int notificationDuration = 5000;
        public int maxNotifications = 3;
    }

    public static enum Theme {
        DARK("Dark", -14935010, -13882322, -16777216),
        LIGHT("Light", -1, -657931, -1118482),
        MIDNIGHT("Midnight", -16119281, -15066578, -16777216),
        OCEAN("Ocean", -15785945, -14665149, -13872284);

        public final String name;
        public final int primaryBg;
        public final int secondaryBg;
        public final int tertiaryBg;

        private Theme(String name, int primaryBg, int secondaryBg, int tertiaryBg) {
            this.name = name;
            this.primaryBg = primaryBg;
            this.secondaryBg = secondaryBg;
            this.tertiaryBg = tertiaryBg;
        }
    }
}

