/*
 * Decompiled with CFR 0.152.
 */
package com.messaging.client.gui;

import com.messaging.client.gui.MessageScreen;
import com.messaging.network.MessageManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class ContactListScreen
extends class_437 {
    private static final int CONTACT_HEIGHT = 60;
    private static final int PADDING = 10;
    private int scrollOffset = 0;
    private List<ContactEntry> contacts = new ArrayList<ContactEntry>();

    public ContactListScreen() {
        super((class_2561)class_2561.method_43470((String)"Messages"));
        this.loadContacts();
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2715"), button -> this.method_25419()).method_46434(this.field_22789 - 30, 5, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u21bb"), button -> this.loadContacts()).method_46434(this.field_22789 - 55, 5, 20, 20).method_46431());
    }

    private void loadContacts() {
        this.contacts.clear();
        MessageManager manager = MessageManager.getInstance();
        String selfName = null;
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            selfName = client.field_1724.method_5477().getString().toLowerCase();
        }
        HashSet<String> allContactNames = new HashSet<String>();
        allContactNames.addAll(manager.getAllContacts());
        for (String player : manager.getOnlinePlayers()) {
            if (selfName != null && player.equalsIgnoreCase(selfName)) continue;
            allContactNames.add(player);
        }
        if (selfName != null) {
            allContactNames.remove(selfName);
        }
        for (String contact : allContactNames) {
            List<MessageManager.ChatMessage> messages = manager.getMessages(contact);
            boolean isOnline = manager.isPlayerOnline(contact);
            String lastMessage = "";
            long lastTimestamp = 0L;
            int unreadCount = 0;
            if (!messages.isEmpty()) {
                MessageManager.ChatMessage last = messages.get(messages.size() - 1);
                lastMessage = last.content;
                lastTimestamp = last.timestamp;
            }
            this.contacts.add(new ContactEntry(contact, lastMessage, lastTimestamp, isOnline, unreadCount));
        }
        this.contacts.sort((a, b) -> {
            if (a.lastTimestamp > 0L && b.lastTimestamp == 0L) {
                return -1;
            }
            if (b.lastTimestamp > 0L && a.lastTimestamp == 0L) {
                return 1;
            }
            if (a.lastTimestamp > 0L && b.lastTimestamp > 0L) {
                return Long.compare(b.lastTimestamp, a.lastTimestamp);
            }
            if (a.isOnline != b.isOnline) {
                return a.isOnline ? -1 : 1;
            }
            return a.name.compareToIgnoreCase(b.name);
        });
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.loadContacts();
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_25294(0, 0, this.field_22789, this.field_22790, -16777216);
        this.renderHeader(context);
        this.renderContacts(context, mouseX, mouseY);
        context.method_25303(this.field_22793, "\u21bb", this.field_22789 - 55, 5, -1);
        context.method_25303(this.field_22793, "\u2715", this.field_22789 - 30, 5, -1);
    }

    private void renderHeader(class_332 context) {
        int headerHeight = 50;
        context.method_25294(0, 0, this.field_22789, headerHeight, -14935010);
        class_5250 title = class_2561.method_43470((String)"Messages").method_27695(new class_124[]{class_124.field_1068, class_124.field_1067});
        int titleX = 10;
        context.method_51439(this.field_22793, (class_2561)title, titleX, 15, -1, true);
        class_5250 subtitle = class_2561.method_43470((String)(this.contacts.size() + " conversation" + (this.contacts.size() != 1 ? "s" : ""))).method_27692(class_124.field_1080);
        context.method_51439(this.field_22793, (class_2561)subtitle, titleX, 30, -7829368, false);
    }

    private void renderContacts(class_332 context, int mouseX, int mouseY) {
        int headerHeight = 50;
        int startY = headerHeight + 10;
        int endY = this.field_22790;
        context.method_44379(0, startY, this.field_22789, endY);
        int currentY = startY - this.scrollOffset;
        for (ContactEntry contact : this.contacts) {
            if (currentY + 60 >= startY && currentY <= endY) {
                boolean hovered = mouseX >= 10 && mouseX <= this.field_22789 - 10 && mouseY >= currentY && mouseY <= currentY + 60;
                this.renderContact(context, contact, currentY, hovered);
            }
            currentY += 65;
        }
        context.method_44380();
        if (this.contacts.isEmpty()) {
            class_5250 noContacts = class_2561.method_43470((String)"No messages yet").method_27692(class_124.field_1080);
            int x = (this.field_22789 - this.field_22793.method_27525((class_5348)noContacts)) / 2;
            int y = (this.field_22790 - 50) / 2;
            context.method_51439(this.field_22793, (class_2561)noContacts, x, y, -7829368, false);
            class_5250 hint = class_2561.method_43470((String)"Start a conversation by messaging a player").method_27692(class_124.field_1063);
            int hintX = (this.field_22789 - this.field_22793.method_27525((class_5348)hint)) / 2;
            context.method_51439(this.field_22793, (class_2561)hint, hintX, y + 15, -11184811, false);
        }
    }

    private void renderContact(class_332 context, ContactEntry contact, int y, boolean hovered) {
        int bgColor = hovered ? -13882322 : -14935010;
        context.method_25294(10, y, this.field_22789 - 10, y + 60, bgColor);
        class_5250 nameText = class_2561.method_43470((String)contact.name).method_27695(new class_124[]{class_124.field_1068, class_124.field_1067});
        context.method_51439(this.field_22793, (class_2561)nameText, 20, y + 10, -1, false);
        if (contact.isOnline) {
            context.method_25294(this.field_22789 - 10 - 20, y + 12, this.field_22789 - 10 - 14, y + 18, -16711936);
            class_5250 onlineText = class_2561.method_43470((String)"Online").method_27692(class_124.field_1060);
            context.method_51439(this.field_22793, (class_2561)onlineText, this.field_22789 - 10 - 60, y + 10, -16711936, false);
        } else {
            class_5250 offlineText = class_2561.method_43470((String)"Offline").method_27692(class_124.field_1080);
            context.method_51439(this.field_22793, (class_2561)offlineText, this.field_22789 - 10 - 60, y + 10, -7829368, false);
        }
        if (!contact.lastMessage.isEmpty()) {
            Object preview = contact.lastMessage;
            if (((String)preview).length() > 50) {
                preview = ((String)preview).substring(0, 47) + "...";
            }
            class_5250 previewText = class_2561.method_43470((String)preview).method_27692(class_124.field_1080);
            context.method_51439(this.field_22793, (class_2561)previewText, 20, y + 28, -7829368, false);
        }
        if (contact.lastTimestamp > 0L) {
            String timeStr = this.formatTimestamp(contact.lastTimestamp);
            class_5250 timeText = class_2561.method_43470((String)timeStr).method_27692(class_124.field_1063);
            int timeX = this.field_22789 - 10 - 10 - this.field_22793.method_27525((class_5348)timeText);
            context.method_51439(this.field_22793, (class_2561)timeText, timeX, y + 45, -11184811, false);
        }
        if (contact.unreadCount > 0) {
            int badgeSize = 20;
            int badgeX = this.field_22789 - 10 - 30;
            int badgeY = y + 40;
            context.method_25294(badgeX, badgeY, badgeX + badgeSize, badgeY + badgeSize, -16745729);
            String count = String.valueOf(contact.unreadCount);
            class_5250 countText = class_2561.method_43470((String)count);
            int countX = badgeX + (badgeSize - this.field_22793.method_27525((class_5348)countText)) / 2;
            int countY = badgeY + (badgeSize - 8) / 2;
            context.method_51439(this.field_22793, (class_2561)countText, countX, countY, -1, false);
        }
        context.method_25294(20, y + 60 + 4, this.field_22789 - 10 - 10, y + 60 + 5, -13421773);
    }

    private String formatTimestamp(long timestamp) {
        long diff = System.currentTimeMillis() - timestamp;
        long seconds = diff / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        if (days > 0L) {
            return days + "d ago";
        }
        if (hours > 0L) {
            return hours + "h ago";
        }
        if (minutes > 0L) {
            return minutes + "m ago";
        }
        return "Just now";
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int headerHeight = 50;
        int startY = headerHeight + 10;
        int currentY = startY - this.scrollOffset;
        for (ContactEntry contact : this.contacts) {
            if (mouseX >= 10.0 && mouseX <= (double)(this.field_22789 - 10) && mouseY >= (double)currentY && mouseY <= (double)(currentY + 60)) {
                if (this.field_22787 != null) {
                    this.field_22787.method_1507((class_437)new MessageScreen(contact.name));
                }
                return true;
            }
            currentY += 65;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int maxScroll = Math.max(0, this.contacts.size() * 65 - (this.field_22790 - 60));
        this.scrollOffset -= (int)(verticalAmount * 20.0);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, maxScroll));
        return true;
    }

    public boolean method_25421() {
        return false;
    }

    private static class ContactEntry {
        String name;
        String lastMessage;
        long lastTimestamp;
        boolean isOnline;
        int unreadCount;

        ContactEntry(String name, String lastMessage, long lastTimestamp, boolean isOnline, int unreadCount) {
            this.name = name;
            this.lastMessage = lastMessage;
            this.lastTimestamp = lastTimestamp;
            this.isOnline = isOnline;
            this.unreadCount = unreadCount;
        }
    }
}

