/*
 * Decompiled with CFR 0.152.
 */
package com.messaging.network;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.messaging.network.NetworkHandler;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_310;
import net.minecraft.class_8710;

public class MessageManager {
    private static MessageManager instance;
    private final Map<String, List<ChatMessage>> messageHistory = new ConcurrentHashMap<String, List<ChatMessage>>();
    private final Set<String> onlinePlayers = ConcurrentHashMap.newKeySet();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private Path messageStoragePath;

    private MessageManager() {
        this.initializeStorage();
    }

    public static MessageManager getInstance() {
        if (instance == null) {
            instance = new MessageManager();
        }
        return instance;
    }

    private void initializeStorage() {
        try {
            class_310 client = class_310.method_1551();
            if (client.field_1697 != null) {
                this.messageStoragePath = client.field_1697.toPath().resolve("messaging-mod");
                Files.createDirectories(this.messageStoragePath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to create messaging storage directory: " + e.getMessage());
        }
    }

    public void addMessage(String otherPlayer, String content, boolean sentByPlayer, long timestamp) {
        String key = this.normalizePlayerName(otherPlayer);
        List messages = this.messageHistory.computeIfAbsent(key, k -> {
            this.loadMessages((String)k);
            return this.messageHistory.getOrDefault(k, new ArrayList());
        });
        boolean exists = messages.stream().anyMatch(msg -> msg.content.equals(content) && Math.abs(msg.timestamp - timestamp) < 1000L && msg.isSentByPlayer == sentByPlayer);
        if (!exists) {
            messages.add(new ChatMessage(content, sentByPlayer, timestamp));
            messages.sort(Comparator.comparingLong(m -> m.timestamp));
            this.saveMessages(key);
        }
    }

    public List<ChatMessage> getMessages(String otherPlayer) {
        String key = this.normalizePlayerName(otherPlayer);
        if (!this.messageHistory.containsKey(key)) {
            this.loadMessages(key);
        }
        return new ArrayList<ChatMessage>(this.messageHistory.getOrDefault(key, new ArrayList()));
    }

    public void sendMessage(String recipient, String message) {
        long timestamp = System.currentTimeMillis();
        this.addMessage(recipient, message, true, timestamp);
        if (ClientPlayNetworking.canSend(NetworkHandler.SendMessagePayload.ID)) {
            ClientPlayNetworking.send((class_8710)new NetworkHandler.SendMessagePayload(recipient, message));
        }
    }

    public void requestHistory(String otherPlayer) {
        if (ClientPlayNetworking.canSend(NetworkHandler.RequestHistoryPayload.ID)) {
            ClientPlayNetworking.send((class_8710)new NetworkHandler.RequestHistoryPayload(otherPlayer));
        }
    }

    public void loadHistoryFromServer(String recipient, String messagesJson) {
        try {
            List serverMessages = (List)this.gson.fromJson(messagesJson, new TypeToken<List<ChatMessage>>(this){}.getType());
            if (serverMessages != null && !serverMessages.isEmpty()) {
                String msgKey;
                String key = this.normalizePlayerName(recipient);
                List existingMessages = this.messageHistory.getOrDefault(key, new ArrayList());
                HashMap<CallSite, ChatMessage> existingMap = new HashMap<CallSite, ChatMessage>();
                for (ChatMessage msg : existingMessages) {
                    msgKey = msg.content + "_" + msg.timestamp / 1000L + "_" + msg.isSentByPlayer;
                    existingMap.put((CallSite)((Object)msgKey), msg);
                }
                for (ChatMessage msg : serverMessages) {
                    msgKey = msg.content + "_" + msg.timestamp / 1000L + "_" + msg.isSentByPlayer;
                    if (existingMap.containsKey(msgKey)) continue;
                    existingMessages.add(msg);
                }
                existingMessages.sort(Comparator.comparingLong(m -> m.timestamp));
                this.messageHistory.put(key, existingMessages);
                this.saveMessages(key);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to parse message history: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void updateOnlinePlayers(String playersJson) {
        try {
            List players = (List)this.gson.fromJson(playersJson, new TypeToken<List<String>>(this){}.getType());
            if (players != null) {
                this.onlinePlayers.clear();
                for (String player : players) {
                    this.onlinePlayers.add(this.normalizePlayerName(player));
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to parse player list: " + e.getMessage());
        }
    }

    public Set<String> getOnlinePlayers() {
        return new HashSet<String>(this.onlinePlayers);
    }

    public boolean isPlayerOnline(String playerName) {
        return this.onlinePlayers.contains(this.normalizePlayerName(playerName));
    }

    public Set<String> getAllContacts() {
        HashSet<String> contacts = new HashSet<String>(this.messageHistory.keySet());
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            String selfName = this.normalizePlayerName(client.field_1724.method_5477().getString());
            contacts.remove(selfName);
        }
        return contacts;
    }

    private String normalizePlayerName(String playerName) {
        return playerName.toLowerCase();
    }

    private void saveMessages(String playerKey) {
        block8: {
            if (this.messageStoragePath == null) {
                return;
            }
            try {
                File file = this.messageStoragePath.resolve(playerKey + ".json").toFile();
                List<ChatMessage> messages = this.messageHistory.get(playerKey);
                if (messages == null) break block8;
                try (FileWriter writer = new FileWriter(file);){
                    this.gson.toJson(messages, (Appendable)writer);
                    writer.flush();
                }
            }
            catch (IOException e) {
                System.err.println("Failed to save messages for " + playerKey + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void loadMessages(String playerKey) {
        block10: {
            if (this.messageStoragePath == null) {
                return;
            }
            if (this.messageHistory.containsKey(playerKey)) {
                return;
            }
            try {
                File file = this.messageStoragePath.resolve(playerKey + ".json").toFile();
                if (!file.exists()) break block10;
                try (FileReader reader = new FileReader(file);){
                    List messages = (List)this.gson.fromJson((Reader)reader, new TypeToken<List<ChatMessage>>(this){}.getType());
                    if (messages != null) {
                        this.messageHistory.put(playerKey, messages);
                    }
                }
            }
            catch (IOException e) {
                System.err.println("Failed to load messages for " + playerKey + ": " + e.getMessage());
            }
        }
    }

    public void clearHistory(String otherPlayer) {
        String key = this.normalizePlayerName(otherPlayer);
        this.messageHistory.remove(key);
        if (this.messageStoragePath != null) {
            try {
                File file = this.messageStoragePath.resolve(key + ".json").toFile();
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception e) {
                System.err.println("Failed to delete message file: " + e.getMessage());
            }
        }
    }

    public static class ChatMessage {
        public String content;
        public boolean isSentByPlayer;
        public long timestamp;

        public ChatMessage(String content, boolean isSentByPlayer, long timestamp) {
            this.content = content;
            this.isSentByPlayer = isSentByPlayer;
            this.timestamp = timestamp;
        }
    }
}

