/*
 * Decompiled with CFR 0.152.
 */
package com.messaging.client.gui;

import com.messaging.client.gui.ContactListScreen;
import com.messaging.config.ConfigManager;
import com.messaging.network.MessageManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class MessageScreen
extends class_437 {
    private class_342 messageInput;
    private List<MessageManager.ChatMessage> messages = new ArrayList<MessageManager.ChatMessage>();
    private String recipientName;
    private int scrollOffset = 0;
    private static final int PADDING = 10;
    private static final int MESSAGE_SPACING = 8;
    private static final int BUBBLE_PADDING = 8;
    private MessageManager messageManager;
    private int lastMessageCount = 0;
    private int totalContentHeight = 0;
    ConfigManager config = ConfigManager.getInstance();
    ConfigManager.Theme theme = this.config.getTheme();

    public MessageScreen(String recipientName) {
        super((class_2561)class_2561.method_43470((String)"Messages"));
        this.recipientName = recipientName;
        this.messageManager = MessageManager.getInstance();
        this.messages = this.messageManager.getMessages(recipientName);
        this.lastMessageCount = this.messages.size();
        this.messageManager.requestHistory(recipientName);
    }

    public String getRecipientName() {
        return this.recipientName;
    }

    protected void method_25426() {
        super.method_25426();
        int inputHeight = 30;
        int inputY = this.field_22790 - inputHeight - 10;
        this.messageInput = new class_342(this.field_22793, 15, inputY + 5, this.field_22789 - 80 - 10, 20, (class_2561)class_2561.method_43470((String)"Message"));
        this.messageInput.method_1880(256);
        this.messageInput.method_47404((class_2561)class_2561.method_43470((String)"Enter Text...").method_27692(class_124.field_1080));
        this.method_25429((class_364)this.messageInput);
        this.method_48265((class_364)this.messageInput);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Send"), button -> this.sendMessage()).method_46434(this.field_22789 - 70, inputY + 10, 60, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new ContactListScreen());
            }
        }).method_46434(5, 5, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2715"), button -> this.method_25419()).method_46434(this.field_22789 - 30, 5, 20, 20).method_46431());
    }

    private void sendMessage() {
        String message = this.messageInput.method_1882().trim();
        if (!message.isEmpty()) {
            this.messageManager.sendMessage(this.recipientName, message);
            this.messages = this.messageManager.getMessages(this.recipientName);
            this.messageInput.method_1852("");
            this.scrollOffset = 0;
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        List<MessageManager.ChatMessage> currentMessages = this.messageManager.getMessages(this.recipientName);
        if (currentMessages.size() != this.lastMessageCount) {
            this.messages = currentMessages;
            this.lastMessageCount = this.messages.size();
            this.scrollOffset = 0;
        } else {
            this.messages = currentMessages;
        }
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_25294(0, 0, this.field_22789, this.field_22790, this.theme.primaryBg);
        this.renderHeader(context);
        this.renderMessages(context);
        int inputY = this.field_22790 - 40;
        context.method_25294(10, inputY, this.field_22789 - 10, this.field_22790 - 10, this.theme.secondaryBg);
        this.messageInput.method_25394(context, mouseX, mouseY, delta);
    }

    private void renderHeader(class_332 context) {
        int lightTextColor;
        int headerHeight = 50;
        context.method_25294(0, 0, this.field_22789, headerHeight, this.theme.secondaryBg);
        int darkTextColor = -16777216;
        int textColor = lightTextColor = -1;
        class_124 formattingColor = class_124.field_1068;
        String name = this.theme.name;
        if (name == "Light") {
            textColor = darkTextColor;
            formattingColor = class_124.field_1074;
        } else if (name == "Dark") {
            textColor = lightTextColor;
            formattingColor = class_124.field_1068;
        }
        class_5250 nameText = class_2561.method_43470((String)this.recipientName).method_27692(formattingColor);
        int nameX = (this.field_22789 - this.field_22793.method_27525((class_5348)nameText)) / 2;
        context.method_51439(this.field_22793, (class_2561)nameText, nameX, 15, textColor, false);
        boolean isOnline = this.messageManager.isPlayerOnline(this.recipientName);
        class_5250 statusText = isOnline ? class_2561.method_43470((String)"\u25cf Online").method_27692(class_124.field_1060) : class_2561.method_43470((String)"\u25cf Offline").method_27692(class_124.field_1080);
        int statusColor = isOnline ? -16711936 : -7829368;
        int statusX = (this.field_22789 - this.field_22793.method_27525((class_5348)statusText)) / 2;
        context.method_51439(this.field_22793, (class_2561)statusText, statusX, 30, statusColor, false);
    }

    private void renderMessages(class_332 context) {
        int headerHeight = 50;
        int inputAreaHeight = 50;
        int messagesAreaTop = headerHeight + 10;
        int messagesAreaBottom = this.field_22790 - inputAreaHeight - 10;
        int messagesAreaHeight = messagesAreaBottom - messagesAreaTop;
        this.totalContentHeight = 0;
        for (MessageManager.ChatMessage msg : this.messages) {
            List<String> wrappedLines = this.wrapText(msg.content, this.field_22789 - 120);
            int bubbleHeight = wrappedLines.size() * 10 + 16;
            this.totalContentHeight += bubbleHeight + 8;
        }
        context.method_44379(0, messagesAreaTop, this.field_22789, messagesAreaBottom);
        int startY = this.totalContentHeight <= messagesAreaHeight ? messagesAreaTop + 10 : messagesAreaBottom - this.totalContentHeight + this.scrollOffset;
        int currentY = startY;
        for (int i = 0; i < this.messages.size(); ++i) {
            MessageManager.ChatMessage msg = this.messages.get(i);
            currentY = this.renderMessage(context, msg, currentY);
            currentY += 8;
        }
        context.method_44380();
        if (this.messages.isEmpty()) {
            class_5250 noMessages = class_2561.method_43470((String)"No messages yet").method_27692(class_124.field_1080);
            int x = (this.field_22789 - this.field_22793.method_27525((class_5348)noMessages)) / 2;
            int y = (messagesAreaTop + messagesAreaBottom) / 2;
            context.method_51439(this.field_22793, (class_2561)noMessages, x, y, -7829368, false);
        }
    }

    private int renderMessage(class_332 context, MessageManager.ChatMessage message, int topY) {
        int lightTextColor;
        int bubbleColor;
        int bubbleX;
        List<String> wrappedLines = this.wrapText(message.content, this.field_22789 - 120);
        int bubbleHeight = wrappedLines.size() * 10 + 16;
        int maxBubbleWidth = this.field_22789 - 100;
        int bubbleWidth = Math.min(maxBubbleWidth, this.calculateTextWidth(wrappedLines) + 16);
        if (message.isSentByPlayer) {
            bubbleX = this.field_22789 - bubbleWidth - 20;
            bubbleColor = this.config.getSentBubbleColor();
            textColor = -1;
        } else {
            bubbleX = 20;
            bubbleColor = this.config.getReceivedBubbleColor();
            textColor = -1;
        }
        int darkTextColor = -16777216;
        int textColors = lightTextColor = -1;
        String name = this.theme.name;
        if (name == "Light") {
            textColors = darkTextColor;
        } else if (name == "Dark") {
            textColors = lightTextColor;
        }
        this.drawRoundedRect(context, bubbleX, topY, bubbleWidth, bubbleHeight, bubbleColor);
        int textY = topY + 8;
        for (String line : wrappedLines) {
            context.method_51433(this.field_22793, line, bubbleX + 8, textY, textColors, false);
            textY += 10;
        }
        return topY + bubbleHeight;
    }

    private void drawRoundedRect(class_332 context, int x, int y, int width, int height, int color) {
        int radius = 4;
        context.method_25294(x + radius, y, x + width - radius, y + height, color);
        context.method_25294(x, y + radius, x + width, y + height - radius, color);
        context.method_25294(x + 1, y + 1, x + radius, y + radius, color);
        context.method_25294(x + width - radius, y + 1, x + width - 1, y + radius, color);
        context.method_25294(x + 1, y + height - radius, x + radius, y + height - 1, color);
        context.method_25294(x + width - radius, y + height - radius, x + width - 1, y + height - 1, color);
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
            if (this.field_22793.method_1727(testLine) <= maxWidth) {
                if (currentLine.length() > 0) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
            }
            currentLine = new StringBuilder(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines.isEmpty() ? List.of(text) : lines;
    }

    private int calculateTextWidth(List<String> lines) {
        int maxWidth = 0;
        for (String line : lines) {
            maxWidth = Math.max(maxWidth, this.field_22793.method_1727(line));
        }
        return maxWidth;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 || keyCode == 335) {
            this.sendMessage();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int headerHeight = 50;
        int inputAreaHeight = 50;
        int messagesAreaHeight = this.field_22790 - headerHeight - inputAreaHeight - 20;
        if (this.totalContentHeight > messagesAreaHeight) {
            this.scrollOffset += (int)(verticalAmount * 20.0);
            int maxScroll = this.totalContentHeight - messagesAreaHeight;
            this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, maxScroll));
        }
        return true;
    }

    public boolean method_25421() {
        return false;
    }
}

