/*
 * Decompiled with CFR 0.152.
 */
package com.messaging.client.notification;

import com.messaging.client.notification.NotificationManager;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class NotificationRenderer {
    private static final int NOTIFICATION_WIDTH = 300;
    private static final int NOTIFICATION_HEIGHT = 60;
    private static final int NOTIFICATION_PADDING = 10;
    private static final int NOTIFICATION_SPACING = 5;
    private static final int CLOSE_BUTTON_SIZE = 16;
    private NotificationManager.MessageNotification hoveredNotification = null;
    private NotificationManager.MessageNotification hoveredCloseButton = null;

    public void render(class_332 context, int mouseX, int mouseY) {
        class_310 client = class_310.method_1551();
        NotificationManager manager = NotificationManager.getInstance();
        List<NotificationManager.MessageNotification> notifications = manager.getNotifications();
        if (notifications.isEmpty()) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int x = screenWidth - 300 - 20;
        int startY = 20;
        this.hoveredNotification = null;
        this.hoveredCloseButton = null;
        for (int i = 0; i < notifications.size(); ++i) {
            boolean isCloseHovered;
            NotificationManager.MessageNotification notification = notifications.get(i);
            int y = startY + i * 65;
            boolean isHovered = mouseX >= x && mouseX <= x + 300 && mouseY >= y && mouseY <= y + 60;
            boolean bl = isCloseHovered = mouseX >= x + 300 - 16 - 5 && mouseX <= x + 300 - 5 && mouseY >= y + 5 && mouseY <= y + 5 + 16;
            if (isHovered && !isCloseHovered) {
                this.hoveredNotification = notification;
            }
            if (isCloseHovered) {
                this.hoveredCloseButton = notification;
            }
            this.renderNotification(context, notification, x, y, isHovered, isCloseHovered, client.field_1772);
        }
    }

    private void renderNotification(class_332 context, NotificationManager.MessageNotification notification, int x, int y, boolean isHovered, boolean isCloseHovered, class_327 textRenderer) {
        float alpha = notification.getAlpha();
        if (alpha <= 0.0f) {
            return;
        }
        int bgColor = this.applyAlpha(isHovered ? -13882322 : -14935010, alpha);
        int borderColor = this.applyAlpha(-16745729, alpha);
        int textColor = this.applyAlpha(-1, alpha);
        int subTextColor = this.applyAlpha(-7829368, alpha);
        context.method_25294(x + 2, y + 2, x + 300 + 2, y + 60 + 2, this.applyAlpha(-16777216, alpha * 0.3f));
        context.method_25294(x, y, x + 300, y + 60, bgColor);
        context.method_25294(x, y, x + 4, y + 60, borderColor);
        class_5250 senderText = class_2561.method_43470((String)notification.senderName).method_27695(new class_124[]{class_124.field_1068, class_124.field_1067});
        context.method_51439(textRenderer, (class_2561)senderText, x + 10, y + 10, textColor, false);
        Object messagePreview = notification.message;
        if (((String)messagePreview).length() > 40) {
            messagePreview = ((String)messagePreview).substring(0, 37) + "...";
        }
        class_5250 messageText = class_2561.method_43470((String)messagePreview).method_27692(class_124.field_1080);
        context.method_51439(textRenderer, (class_2561)messageText, x + 10, y + 10 + 15, subTextColor, false);
        class_5250 newMsgText = class_2561.method_43470((String)"New Message").method_27692(class_124.field_1063);
        context.method_51439(textRenderer, (class_2561)newMsgText, x + 10, y + 60 - 20, subTextColor, false);
        int closeX = x + 300 - 16 - 5;
        int closeY = y + 5;
        int closeBg = this.applyAlpha(isCloseHovered ? -12303292 : -13882322, alpha);
        context.method_25294(closeX, closeY, closeX + 16, closeY + 16, closeBg);
        class_5250 closeText = class_2561.method_43470((String)"\u2715");
        int closeTextX = closeX + (16 - textRenderer.method_27525((class_5348)closeText)) / 2;
        int closeTextY = closeY + 4;
        context.method_51439(textRenderer, (class_2561)closeText, closeTextX, closeTextY, textColor, false);
        if (isHovered && !isCloseHovered) {
            class_5250 clickText = class_2561.method_43470((String)"Click to view").method_27692(class_124.field_1075);
            int clickX = x + 300 - textRenderer.method_27525((class_5348)clickText) - 10;
            context.method_51439(textRenderer, (class_2561)clickText, clickX, y + 60 - 20, this.applyAlpha(-16711681, alpha), false);
        }
    }

    private int applyAlpha(int color, float alpha) {
        int a = (int)(alpha * 255.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        NotificationManager manager = NotificationManager.getInstance();
        if (this.hoveredCloseButton != null) {
            manager.removeNotification(this.hoveredCloseButton);
            return true;
        }
        if (this.hoveredNotification != null) {
            manager.openNotification(this.hoveredNotification);
            return true;
        }
        return false;
    }
}

