/*
 * Decompiled with CFR 0.152.
 */
package io.github.thevoidblock.syncac.util;

import io.github.thevoidblock.syncac.Syncac;
import io.github.thevoidblock.syncac.SyncacConfig;
import io.github.thevoidblock.syncac.autoclicker.AttackAutoClicker;
import io.github.thevoidblock.syncac.autoclicker.AutoClickerConfig;
import io.github.thevoidblock.syncac.autoclicker.UseAutoClicker;
import io.github.thevoidblock.syncac.util.GetCarpetLoggerInfo;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;

public class AutoClicker {
    private static final long TICK_TO_NANO = 50000000L;

    public static void registerAutoClickers() {
        AutoClicker.registerAutoClicker(new AttackAutoClicker());
        AutoClicker.registerAutoClicker(new UseAutoClicker());
    }

    public static void registerAutoClicker(AutoClickerConfig clicker) {
        clicker.startTime = System.nanoTime();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            SyncacConfig config = Syncac.getConfig();
            if (config.modEnabled && clicker.isEnabled()) {
                if (clicker.isSync()) {
                    clicker.syncInterval = GetCarpetLoggerInfo.getTPS() <= 20.0 ? (long)((int)Math.max((double)clicker.getInterval() * (20.0 / GetCarpetLoggerInfo.getTPS()), (double)clicker.syncInterval)) : (long)((int)Math.min((double)clicker.getInterval() * (20.0 / GetCarpetLoggerInfo.getTPS()), (double)clicker.syncInterval));
                }
                if (System.nanoTime() - clicker.startTime >= clicker.syncInterval * 50000000L) {
                    clicker.run();
                    clicker.syncInterval = clicker.getInterval();
                    clicker.startTime = System.nanoTime();
                }
            }
        });
    }
}

