/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.CursorType;
import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoQueryException;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncCommandBatchCursor;
import com.mongodb.internal.operation.AsyncExplainableReadOperation;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.CommandBatchCursor;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.CommandReadOperation;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.ExplainHelper;
import com.mongodb.internal.operation.ExplainableReadOperation;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.OperationReadConcernHelper;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.lang.Nullable;
import java.util.function.Supplier;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.Decoder;

public class FindOperation<T>
implements AsyncExplainableReadOperation<AsyncBatchCursor<T>>,
ExplainableReadOperation<BatchCursor<T>> {
    private static final String FIRST_BATCH = "firstBatch";
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    private boolean retryReads;
    private BsonDocument filter;
    private int batchSize;
    private int limit;
    private BsonDocument projection;
    private int skip;
    private BsonDocument sort;
    private CursorType cursorType = CursorType.NonTailable;
    private boolean noCursorTimeout;
    private boolean partial;
    private Collation collation;
    private BsonValue comment;
    private BsonValue hint;
    private BsonDocument variables;
    private BsonDocument max;
    private BsonDocument min;
    private boolean returnKey;
    private boolean showRecordId;
    private Boolean allowDiskUse;
    private TimeoutMode timeoutMode;

    public FindOperation(MongoNamespace namespace, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public FindOperation<T> filter(@Nullable BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public FindOperation<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public FindOperation<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public BsonDocument getProjection() {
        return this.projection;
    }

    public FindOperation<T> projection(@Nullable BsonDocument projection) {
        this.projection = projection;
        return this;
    }

    public int getSkip() {
        return this.skip;
    }

    public FindOperation<T> skip(int skip) {
        this.skip = skip;
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public FindOperation<T> sort(@Nullable BsonDocument sort) {
        this.sort = sort;
        return this;
    }

    public CursorType getCursorType() {
        return this.cursorType;
    }

    public FindOperation<T> cursorType(CursorType cursorType) {
        this.cursorType = Assertions.notNull("cursorType", cursorType);
        return this;
    }

    public FindOperation<T> timeoutMode(@Nullable TimeoutMode timeoutMode) {
        if (timeoutMode != null) {
            this.timeoutMode = timeoutMode;
        }
        return this;
    }

    public boolean isNoCursorTimeout() {
        return this.noCursorTimeout;
    }

    public FindOperation<T> noCursorTimeout(boolean noCursorTimeout) {
        this.noCursorTimeout = noCursorTimeout;
        return this;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public FindOperation<T> partial(boolean partial) {
        this.partial = partial;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public FindOperation<T> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    public BsonValue getComment() {
        return this.comment;
    }

    public FindOperation<T> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    public BsonValue getHint() {
        return this.hint;
    }

    public FindOperation<T> hint(@Nullable BsonValue hint) {
        this.hint = hint;
        return this;
    }

    public BsonDocument getLet() {
        return this.variables;
    }

    public FindOperation<T> let(@Nullable BsonDocument variables) {
        this.variables = variables;
        return this;
    }

    public BsonDocument getMax() {
        return this.max;
    }

    public FindOperation<T> max(@Nullable BsonDocument max) {
        this.max = max;
        return this;
    }

    public BsonDocument getMin() {
        return this.min;
    }

    public FindOperation<T> min(@Nullable BsonDocument min) {
        this.min = min;
        return this;
    }

    public boolean isReturnKey() {
        return this.returnKey;
    }

    public FindOperation<T> returnKey(boolean returnKey) {
        this.returnKey = returnKey;
        return this;
    }

    public boolean isShowRecordId() {
        return this.showRecordId;
    }

    public FindOperation<T> showRecordId(boolean showRecordId) {
        this.showRecordId = showRecordId;
        return this;
    }

    public FindOperation<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    public Boolean isAllowDiskUse() {
        return this.allowDiskUse;
    }

    public FindOperation<T> allowDiskUse(@Nullable Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        IllegalStateException invalidTimeoutModeException = this.invalidTimeoutModeException();
        if (invalidTimeoutModeException != null) {
            throw invalidTimeoutModeException;
        }
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads, binding.getOperationContext().getTimeoutContext());
        Supplier<BatchCursor> read = SyncOperationHelper.decorateReadWithRetries(retryState, binding.getOperationContext(), () -> SyncOperationHelper.withSourceAndConnection(binding::getReadConnectionSource, false, (source, connection) -> {
            retryState.breakAndThrowIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), binding.getOperationContext()));
            try {
                return SyncOperationHelper.createReadCommandAndExecute(retryState, binding.getOperationContext(), source, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, FIRST_BATCH), this.transformer(), connection);
            }
            catch (MongoCommandException e) {
                throw new MongoQueryException(e.getResponse(), e.getServerAddress());
            }
        }));
        return read.get();
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        IllegalStateException invalidTimeoutModeException = this.invalidTimeoutModeException();
        if (invalidTimeoutModeException != null) {
            callback.onResult(null, invalidTimeoutModeException);
            return;
        }
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads, binding.getOperationContext().getTimeoutContext());
        binding.retain();
        AsyncCallbackSupplier<AsyncBatchCursor<T>> asyncRead = AsyncOperationHelper.decorateReadWithRetriesAsync(retryState, binding.getOperationContext(), funcCallback -> AsyncOperationHelper.withAsyncSourceAndConnection(binding::getReadConnectionSource, false, funcCallback, (source, connection, releasingCallback) -> {
            if (retryState.breakAndCompleteIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), binding.getOperationContext()), releasingCallback)) {
                return;
            }
            SingleResultCallback<T> wrappedCallback = FindOperation.exceptionTransformingCallback(releasingCallback);
            AsyncOperationHelper.createReadCommandAndExecuteAsync(retryState, binding.getOperationContext(), source, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, FIRST_BATCH), this.asyncTransformer(), connection, wrappedCallback);
        })).whenComplete(binding::release);
        asyncRead.get(ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    private static <T> SingleResultCallback<T> exceptionTransformingCallback(SingleResultCallback<T> callback) {
        return (result, t) -> {
            if (t != null) {
                if (t instanceof MongoCommandException) {
                    MongoCommandException commandException = (MongoCommandException)t;
                    callback.onResult(result, new MongoQueryException(commandException.getResponse(), commandException.getServerAddress()));
                } else {
                    callback.onResult(result, t);
                }
            } else {
                callback.onResult(result, null);
            }
        };
    }

    @Override
    public <R> ReadOperation<R> asExplainableOperation(@Nullable ExplainVerbosity verbosity, Decoder<R> resultDecoder) {
        return this.createExplainableOperation(verbosity, resultDecoder);
    }

    @Override
    public <R> AsyncReadOperation<R> asAsyncExplainableOperation(@Nullable ExplainVerbosity verbosity, Decoder<R> resultDecoder) {
        return this.createExplainableOperation(verbosity, resultDecoder);
    }

    <R> CommandReadOperation<R> createExplainableOperation(@Nullable ExplainVerbosity verbosity, Decoder<R> resultDecoder) {
        return new CommandReadOperation<R>(this.getNamespace().getDatabaseName(), (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument command = this.getCommand(operationContext, 0);
            CommandHelper.applyMaxTimeMS(operationContext.getTimeoutContext(), command);
            return ExplainHelper.asExplainCommand(command, verbosity);
        }, resultDecoder);
    }

    private BsonDocument getCommand(OperationContext operationContext, int maxWireVersion) {
        BsonDocument commandDocument = new BsonDocument("find", new BsonString(this.namespace.getCollectionName()));
        OperationReadConcernHelper.appendReadConcernToCommand(operationContext.getSessionContext(), maxWireVersion, commandDocument);
        DocumentHelper.putIfNotNull(commandDocument, "filter", this.filter);
        DocumentHelper.putIfNotNullOrEmpty(commandDocument, "sort", this.sort);
        DocumentHelper.putIfNotNullOrEmpty(commandDocument, "projection", this.projection);
        if (this.skip > 0) {
            commandDocument.put("skip", new BsonInt32(this.skip));
        }
        if (this.limit != 0) {
            commandDocument.put("limit", new BsonInt32(Math.abs(this.limit)));
        }
        if (this.limit >= 0) {
            if (this.batchSize < 0 && Math.abs(this.batchSize) < this.limit) {
                commandDocument.put("limit", new BsonInt32(Math.abs(this.batchSize)));
            } else if (this.batchSize != 0) {
                commandDocument.put("batchSize", new BsonInt32(Math.abs(this.batchSize)));
            }
        }
        if (this.limit < 0 || this.batchSize < 0) {
            commandDocument.put("singleBatch", BsonBoolean.TRUE);
        }
        if (this.isTailableCursor()) {
            commandDocument.put("tailable", BsonBoolean.TRUE);
            if (this.isAwaitData()) {
                commandDocument.put("awaitData", BsonBoolean.TRUE);
            } else {
                operationContext.getTimeoutContext().disableMaxTimeOverride();
            }
        } else {
            OperationHelper.setNonTailableCursorMaxTimeSupplier(this.timeoutMode, operationContext);
        }
        if (this.noCursorTimeout) {
            commandDocument.put("noCursorTimeout", BsonBoolean.TRUE);
        }
        if (this.partial) {
            commandDocument.put("allowPartialResults", BsonBoolean.TRUE);
        }
        if (this.collation != null) {
            commandDocument.put("collation", this.collation.asDocument());
        }
        if (this.comment != null) {
            commandDocument.put("comment", this.comment);
        }
        if (this.hint != null) {
            commandDocument.put("hint", this.hint);
        }
        if (this.variables != null) {
            commandDocument.put("let", this.variables);
        }
        if (this.max != null) {
            commandDocument.put("max", this.max);
        }
        if (this.min != null) {
            commandDocument.put("min", this.min);
        }
        if (this.returnKey) {
            commandDocument.put("returnKey", BsonBoolean.TRUE);
        }
        if (this.showRecordId) {
            commandDocument.put("showRecordId", BsonBoolean.TRUE);
        }
        if (this.allowDiskUse != null) {
            commandDocument.put("allowDiskUse", BsonBoolean.valueOf(this.allowDiskUse));
        }
        return commandDocument;
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> this.getCommand(operationContext, connectionDescription.getMaxWireVersion());
    }

    private boolean isTailableCursor() {
        return this.cursorType.isTailable();
    }

    private boolean isAwaitData() {
        return this.cursorType == CursorType.TailableAwait;
    }

    private TimeoutMode getTimeoutMode() {
        if (this.timeoutMode == null) {
            return this.isTailableCursor() ? TimeoutMode.ITERATION : TimeoutMode.CURSOR_LIFETIME;
        }
        return this.timeoutMode;
    }

    private SyncOperationHelper.CommandReadTransformer<BsonDocument, CommandBatchCursor<T>> transformer() {
        return (result, source, connection) -> new CommandBatchCursor<T>(this.getTimeoutMode(), (BsonDocument)result, this.batchSize, this.getMaxTimeForCursor(source.getOperationContext()), this.decoder, this.comment, source, connection);
    }

    private AsyncOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncTransformer() {
        return (result, source, connection) -> new AsyncCommandBatchCursor<T>(this.getTimeoutMode(), (BsonDocument)result, this.batchSize, this.getMaxTimeForCursor(source.getOperationContext()), this.decoder, this.comment, source, connection);
    }

    private long getMaxTimeForCursor(OperationContext operationContext) {
        return this.cursorType == CursorType.TailableAwait ? operationContext.getTimeoutContext().getMaxAwaitTimeMS() : 0L;
    }

    @Nullable
    private IllegalStateException invalidTimeoutModeException() {
        if (this.isTailableCursor() && this.timeoutMode == TimeoutMode.CURSOR_LIFETIME) {
            return new IllegalStateException("Tailable cursors only support the ITERATION value for the timeoutMode option.");
        }
        return null;
    }
}

