/*
 * Decompiled with CFR 0.152.
 */
package com.infernalsuite.asp.loaders.file;

import com.infernalsuite.asp.api.exceptions.UnknownWorldException;
import com.infernalsuite.asp.api.loaders.SlimeLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.NotDirectoryException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLoader
implements SlimeLoader {
    private static final FilenameFilter WORLD_FILE_FILTER = (dir, name) -> name.endsWith(".slime");
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLoader.class);
    private final File worldDir;

    public FileLoader(File worldDir) throws IllegalStateException {
        this.worldDir = worldDir;
        if (worldDir.exists() && !worldDir.isDirectory()) {
            LOGGER.warn("A file named '{}' has been deleted, as this is the name used for the worlds directory.", (Object)worldDir.getName());
            if (!worldDir.delete()) {
                throw new IllegalStateException("Failed to delete the file named '" + worldDir.getName() + "'.");
            }
        }
        if (!worldDir.exists() && !worldDir.mkdirs()) {
            throw new IllegalStateException("Failed to create the worlds directory.");
        }
    }

    public byte[] readWorld(String worldName) throws UnknownWorldException, IOException {
        if (!this.worldExists(worldName)) {
            throw new UnknownWorldException(worldName);
        }
        try (FileInputStream fis = new FileInputStream(new File(this.worldDir, worldName + ".slime"));){
            byte[] byArray = fis.readAllBytes();
            return byArray;
        }
    }

    public boolean worldExists(String worldName) {
        return new File(this.worldDir, worldName + ".slime").exists();
    }

    public List<String> listWorlds() throws NotDirectoryException {
        String[] worlds = this.worldDir.list(WORLD_FILE_FILTER);
        if (worlds == null) {
            throw new NotDirectoryException(this.worldDir.getPath());
        }
        return Arrays.stream(worlds).map(c -> c.substring(0, c.length() - 6)).collect(Collectors.toList());
    }

    public void saveWorld(String worldName, byte[] serializedWorld) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(new File(this.worldDir, worldName + ".slime"));){
            fos.write(serializedWorld);
        }
    }

    public void deleteWorld(String worldName) throws UnknownWorldException, IOException {
        if (!this.worldExists(worldName)) {
            throw new UnknownWorldException(worldName);
        }
        if (!new File(this.worldDir, worldName + ".slime").delete()) {
            throw new IOException("Failed to delete the world file. File#delete() returned false.");
        }
    }
}

