/*
 * Decompiled with CFR 0.152.
 */
package com.infernalsuite.asp.loaders.mysql;

import com.infernalsuite.asp.api.exceptions.UnknownWorldException;
import com.infernalsuite.asp.api.loaders.UpdatableLoader;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlLoader
extends UpdatableLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MysqlLoader.class);
    private static final int CURRENT_DB_VERSION = 1;
    private static final String CREATE_VERSIONING_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS `database_version` (`id` INT NOT NULL AUTO_INCREMENT, `version` INT(11), PRIMARY KEY(id));";
    private static final String INSERT_VERSION_QUERY = "INSERT INTO `database_version` (`id`, `version`) VALUES (1, ?) ON DUPLICATE KEY UPDATE `id` = ?;";
    private static final String GET_VERSION_QUERY = "SELECT `version` FROM `database_version` WHERE `id` = 1;";
    private static final String ALTER_LOCKED_COLUMN_QUERY = "ALTER TABLE `worlds` CHANGE COLUMN `locked` `locked` BIGINT NOT NULL DEFAULT 0;";
    private static final String CREATE_WORLDS_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS `worlds` (`id` INT NOT NULL AUTO_INCREMENT, `name` VARCHAR(255) UNIQUE, `locked` BIGINT, `world` MEDIUMBLOB, PRIMARY KEY(id));";
    private static final String SELECT_WORLD_QUERY = "SELECT `world` FROM `worlds` WHERE `name` = ?;";
    private static final String UPDATE_WORLD_QUERY = "INSERT INTO `worlds` (`name`, `world`) VALUES (?, ?) ON DUPLICATE KEY UPDATE `world` = ?;";
    private static final String DELETE_WORLD_QUERY = "DELETE FROM `worlds` WHERE `name` = ?;";
    private static final String LIST_WORLDS_QUERY = "SELECT `name` FROM `worlds`;";
    private final HikariDataSource source;

    public MysqlLoader(String sqlURL, String host, int port, String database, boolean useSSL, String username, String password) throws SQLException {
        HikariConfig hikariConfig = new HikariConfig();
        sqlURL = sqlURL.replace("{host}", host);
        sqlURL = sqlURL.replace("{port}", String.valueOf(port));
        sqlURL = sqlURL.replace("{database}", database);
        sqlURL = sqlURL.replace("{usessl}", String.valueOf(useSSL));
        hikariConfig.setJdbcUrl(sqlURL);
        hikariConfig.setUsername(username);
        hikariConfig.setPassword(password);
        hikariConfig.addDataSourceProperty("cachePrepStmts", "true");
        hikariConfig.addDataSourceProperty("prepStmtCacheSize", "250");
        hikariConfig.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        hikariConfig.addDataSourceProperty("useServerPrepStmts", "true");
        hikariConfig.addDataSourceProperty("useLocalSessionState", "true");
        hikariConfig.addDataSourceProperty("rewriteBatchedStatements", "true");
        hikariConfig.addDataSourceProperty("cacheResultSetMetadata", "true");
        hikariConfig.addDataSourceProperty("cacheServerConfiguration", "true");
        hikariConfig.addDataSourceProperty("elideSetAutoCommits", "true");
        hikariConfig.addDataSourceProperty("maintainTimeStats", "false");
        this.source = new HikariDataSource(hikariConfig);
        try (Connection con = this.source.getConnection();){
            try (PreparedStatement statement = con.prepareStatement(CREATE_WORLDS_TABLE_QUERY);){
                statement.execute();
            }
            statement = con.prepareStatement(CREATE_VERSIONING_TABLE_QUERY);
            try {
                statement.execute();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    public void update() throws IOException, UpdatableLoader.NewerStorageException {
        block38: {
            try (Connection con = this.source.getConnection();){
                int version;
                try (PreparedStatement statement = con.prepareStatement(GET_VERSION_QUERY);
                     ResultSet set2 = statement.executeQuery();){
                    version = set2.next() ? set2.getInt(1) : -1;
                }
                if (version > 1) {
                    throw new UpdatableLoader.NewerStorageException(1, version);
                }
                if (version >= 1) break block38;
                LOGGER.warn("Your SWM MySQL database is outdated. The update process will start in 10 seconds.");
                LOGGER.warn("Note that this update might make your database incompatible with older SWM versions.");
                LOGGER.warn("Make sure no other servers with older SWM versions are using this database.");
                LOGGER.warn("Shut down the server to prevent your database from being updated.");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ignored) {
                    LOGGER.info("Update process aborted.");
                    if (con != null) {
                        con.close();
                    }
                    return;
                }
                statement = con.prepareStatement(ALTER_LOCKED_COLUMN_QUERY);
                try {
                    statement.executeUpdate();
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
                statement = con.prepareStatement(INSERT_VERSION_QUERY);
                try {
                    statement.setInt(1, 1);
                    statement.setInt(2, 1);
                    statement.executeUpdate();
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (SQLException ex) {
                throw new IOException(ex);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] readWorld(String worldName) throws UnknownWorldException, IOException {
        try (Connection con = this.source.getConnection();){
            byte[] byArray;
            block15: {
                PreparedStatement statement = con.prepareStatement(SELECT_WORLD_QUERY);
                try {
                    statement.setString(1, worldName);
                    ResultSet set2 = statement.executeQuery();
                    if (!set2.next()) {
                        throw new UnknownWorldException(worldName);
                    }
                    byArray = set2.getBytes("world");
                    if (statement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return byArray;
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean worldExists(String worldName) throws IOException {
        try (Connection con = this.source.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = con.prepareStatement(SELECT_WORLD_QUERY);
                try {
                    statement.setString(1, worldName);
                    ResultSet set2 = statement.executeQuery();
                    bl = set2.next();
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    public List<String> listWorlds() throws IOException {
        ArrayList<String> worldList = new ArrayList<String>();
        try (Connection con = this.source.getConnection();
             PreparedStatement statement = con.prepareStatement(LIST_WORLDS_QUERY);){
            ResultSet set2 = statement.executeQuery();
            while (set2.next()) {
                worldList.add(set2.getString("name"));
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
        return worldList;
    }

    public void saveWorld(String worldName, byte[] serializedWorld) throws IOException {
        try (Connection con = this.source.getConnection();
             PreparedStatement statement = con.prepareStatement(UPDATE_WORLD_QUERY);){
            statement.setString(1, worldName);
            statement.setBytes(2, serializedWorld);
            statement.setBytes(3, serializedWorld);
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    public void deleteWorld(String worldName) throws IOException, UnknownWorldException {
        try (Connection con = this.source.getConnection();
             PreparedStatement statement = con.prepareStatement(DELETE_WORLD_QUERY);){
            statement.setString(1, worldName);
            if (statement.executeUpdate() == 0) {
                throw new UnknownWorldException(worldName);
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }
}

