/*
 * Decompiled with CFR 0.152.
 */
package com.infernalsuite.asp.loaders.redis;

import com.infernalsuite.asp.api.exceptions.UnknownWorldException;
import com.infernalsuite.asp.api.loaders.SlimeLoader;
import com.infernalsuite.asp.loaders.redis.util.StringByteCodec;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.sync.RedisCommands;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;

public class RedisLoader
implements SlimeLoader {
    private static final String WORLD_DATA_PREFIX = "aswm:world:data:";
    private static final String WORLD_LIST_PREFIX = "aswm:world:list";
    private final RedisCommands<String, byte[]> connection;

    public RedisLoader(String uri) {
        this.connection = RedisClient.create(uri).connect(StringByteCodec.INSTANCE).sync();
    }

    public byte[] readWorld(String name) throws UnknownWorldException, IOException {
        byte[] data = (byte[])this.connection.get(WORLD_DATA_PREFIX + name);
        if (data == null) {
            throw new UnknownWorldException(name);
        }
        return data;
    }

    public boolean worldExists(String name) throws IOException {
        return this.connection.exists((String[])new String[]{WORLD_DATA_PREFIX + name}) == 1L;
    }

    public List<String> listWorlds() throws IOException {
        return this.connection.smembers(WORLD_LIST_PREFIX).stream().map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8)).collect(Collectors.toList());
    }

    public void saveWorld(String worldName, byte[] bytes) throws IOException {
        this.connection.set(WORLD_DATA_PREFIX + worldName, bytes);
        this.connection.sadd(WORLD_LIST_PREFIX, (V[])new byte[][]{worldName.getBytes(StandardCharsets.UTF_8)});
    }

    public void deleteWorld(String worldName) throws UnknownWorldException, IOException {
        long deletedCount = this.connection.del((String[])new String[]{WORLD_DATA_PREFIX + worldName});
        if (deletedCount == 0L) {
            throw new UnknownWorldException(worldName);
        }
        this.connection.srem(WORLD_LIST_PREFIX, (V[])new byte[][]{worldName.getBytes(StandardCharsets.UTF_8)});
    }
}

