/*
 * Decompiled with CFR 0.152.
 */
package dev.danielmillar.slimelink.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import com.infernalsuite.asp.api.world.properties.SlimeProperty;
import com.infernalsuite.asp.api.world.properties.SlimePropertyMap;
import dev.danielmillar.slimelink.slime.SlimePropertiesEnum;
import dev.danielmillar.slimelink.util.Util;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Slime Property Value")
@Description(value={"Check the value of a SlimeProperty in a SlimePropertyMap."})
@Examples(value={"if slime property spawn x of slimePropertyMap is 5", "if slime property allow monsters of slimePropertyMap isn't true"})
@Since(value={"1.0.0"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J=\u0010\u0011\u001a\u00020\u00102\u0014\u0010\u0012\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldev/danielmillar/slimelink/skript/conditions/CondSlimePropertyValue;", "Lch/njol/skript/lang/Condition;", "<init>", "()V", "slimePropertyType", "Lch/njol/skript/lang/Expression;", "Ldev/danielmillar/slimelink/slime/SlimePropertiesEnum;", "slimeProperties", "Lcom/infernalsuite/asp/api/world/properties/SlimePropertyMap;", "value", "Ljava/lang/Object;", "toString", "", "event", "Lorg/bukkit/event/Event;", "debug", "", "init", "expressions", "", "matchedPattern", "", "isDelayed", "Lch/njol/util/Kleenean;", "parseResult", "Lch/njol/skript/lang/SkriptParser$ParseResult;", "([Lch/njol/skript/lang/Expression;ILch/njol/util/Kleenean;Lch/njol/skript/lang/SkriptParser$ParseResult;)Z", "check", "Companion", "SlimeLink"})
public final class CondSlimePropertyValue
extends Condition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Expression<SlimePropertiesEnum> slimePropertyType;
    private Expression<SlimePropertyMap> slimeProperties;
    private Expression<Object> value;

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        Expression<SlimePropertiesEnum> expression = this.slimePropertyType;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("slimePropertyType");
            expression = null;
        }
        String string = expression.toString(event, debug);
        Expression<SlimePropertyMap> expression2 = this.slimeProperties;
        if (expression2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("slimeProperties");
            expression2 = null;
        }
        String string2 = expression2.toString(event, debug);
        String string3 = this.isNegated() ? "isn't" : "is";
        Expression<Object> expression3 = this.value;
        if (expression3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("value");
            expression3 = null;
        }
        return string + " of " + string2 + " " + string3 + " " + expression3.toString(event, debug);
    }

    public boolean init(@NotNull Expression<?>[] expressions, int matchedPattern, @Nullable Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        Intrinsics.checkNotNullParameter(expressions, "expressions");
        Intrinsics.checkNotNullParameter(parseResult, "parseResult");
        Expression<?> expression = expressions[0];
        Intrinsics.checkNotNull(expression, "null cannot be cast to non-null type ch.njol.skript.lang.Expression<dev.danielmillar.slimelink.slime.SlimePropertiesEnum>");
        this.slimePropertyType = expression;
        Expression<?> expression2 = expressions[1];
        Intrinsics.checkNotNull(expression2, "null cannot be cast to non-null type ch.njol.skript.lang.Expression<com.infernalsuite.asp.api.world.properties.SlimePropertyMap>");
        this.slimeProperties = expression2;
        Expression expression3 = LiteralUtils.defendExpression(expressions[2]);
        Intrinsics.checkNotNullExpressionValue(expression3, "defendExpression(...)");
        this.value = expression3;
        this.setNegated(parseResult.hasTag("1"));
        Expression[] expressionArray = new Expression[1];
        Expression<Object> expression4 = this.value;
        if (expression4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("value");
            expression4 = null;
        }
        expressionArray[0] = expression4;
        return LiteralUtils.canInitSafely((Expression[])expressionArray);
    }

    public boolean check(@Nullable Event event) {
        SlimePropertiesEnum property;
        SlimePropertyMap properties;
        if (event == null) {
            return false;
        }
        Expression<Object> expression = this.value;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("value");
            expression = null;
        }
        Object object = expression.getSingle(event);
        if (object == null) {
            return false;
        }
        Object valueObj = object;
        Expression<SlimePropertyMap> expression2 = this.slimeProperties;
        if (expression2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("slimeProperties");
            expression2 = null;
        }
        if ((properties = (SlimePropertyMap)expression2.getSingle(event)) == null) {
            Skript.error((String)"Provided slime properties is null");
            return false;
        }
        Expression<SlimePropertiesEnum> expression3 = this.slimePropertyType;
        if (expression3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("slimePropertyType");
            expression3 = null;
        }
        if ((property = (SlimePropertiesEnum)((Object)expression3.getSingle(event))) == null) {
            Skript.error((String)"Slime property is null");
            return false;
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to("String", CondSlimePropertyValue::check$lambda$0), TuplesKt.to("Integer", CondSlimePropertyValue::check$lambda$1), TuplesKt.to("Float", CondSlimePropertyValue::check$lambda$2), TuplesKt.to("Boolean", CondSlimePropertyValue::check$lambda$3)};
        Map converters = MapsKt.mapOf(pairArray);
        Function1 function1 = (Function1)converters.get(property.getDataType());
        if (function1 == null) {
            return false;
        }
        Function1 converter = function1;
        Object compareValue = converter.invoke(valueObj);
        if (compareValue == null && !Intrinsics.areEqual(property.getDataType(), "String")) {
            Skript.error((String)("Expected a " + property.getDataType() + " value for property " + property.name() + " but got " + Reflection.getOrCreateKotlinClass(valueObj.getClass()).getSimpleName() + " instead"));
            return false;
        }
        return switch (property.getDataType()) {
            case "String" -> {
                SlimeProperty<?, ?> v5 = property.getProp();
                Intrinsics.checkNotNull(v5, "null cannot be cast to non-null type com.infernalsuite.asp.api.world.properties.SlimeProperty<kotlin.String, *>");
                yield CondSlimePropertyValue.check$compareProperty(properties, this, v5, compareValue);
            }
            case "Integer" -> {
                SlimeProperty<?, ?> v7 = property.getProp();
                Intrinsics.checkNotNull(v7, "null cannot be cast to non-null type com.infernalsuite.asp.api.world.properties.SlimeProperty<kotlin.Int, *>");
                yield CondSlimePropertyValue.check$compareProperty(properties, this, v7, compareValue);
            }
            case "Float" -> {
                SlimeProperty<?, ?> v8 = property.getProp();
                Intrinsics.checkNotNull(v8, "null cannot be cast to non-null type com.infernalsuite.asp.api.world.properties.SlimeProperty<kotlin.Float, *>");
                yield CondSlimePropertyValue.check$compareProperty(properties, this, v8, compareValue);
            }
            case "Boolean" -> {
                SlimeProperty<?, ?> v9 = property.getProp();
                Intrinsics.checkNotNull(v9, "null cannot be cast to non-null type com.infernalsuite.asp.api.world.properties.SlimeProperty<kotlin.Boolean, *>");
                yield CondSlimePropertyValue.check$compareProperty(properties, this, v9, compareValue);
            }
            default -> false;
        };
    }

    private static final Object check$lambda$0(Object it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.toString();
    }

    private static final Object check$lambda$1(Object it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Util.INSTANCE.anyToInt(it);
    }

    private static final Object check$lambda$2(Object it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Util.INSTANCE.anyToFloat(it);
    }

    private static final Object check$lambda$3(Object it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Util.INSTANCE.anyToBoolean(it);
    }

    private static final <T> boolean check$compareProperty(SlimePropertyMap properties, CondSlimePropertyValue this$0, SlimeProperty<T, ?> prop, Object value) {
        Object propValue = properties.getValue(prop);
        return this$0.isNegated() ? !Intrinsics.areEqual(propValue, value) : Intrinsics.areEqual(propValue, value);
    }

    static {
        String[] stringArray = new String[]{"slime property %slimeproperty% of %slimepropertymap% (is|1:is(n't| not)) %object%"};
        Skript.registerCondition(CondSlimePropertyValue.class, (String[])stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldev/danielmillar/slimelink/skript/conditions/CondSlimePropertyValue$Companion;", "", "<init>", "()V", "SlimeLink"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

