/*
 * Decompiled with CFR 0.152.
 */
package dev.danielmillar.slimelink.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="SlimeWorld Loaded")
@Description(value={"Check if a SlimeWorld is currently loaded on the server."})
@Examples(value={"if slime world named \"MySlimeWorld\" is loaded:", "if slime world named \"MySlimeWorld\" isn't loaded:"})
@Since(value={"1.0.0"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J=\u0010\f\u001a\u00020\u000b2\u0014\u0010\r\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0012\u0010\u0016\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldev/danielmillar/slimelink/skript/conditions/CondSlimeWorldLoaded;", "Lch/njol/skript/lang/Condition;", "<init>", "()V", "worldName", "Lch/njol/skript/lang/Expression;", "", "toString", "event", "Lorg/bukkit/event/Event;", "debug", "", "init", "expressions", "", "matchedPattern", "", "isDelayed", "Lch/njol/util/Kleenean;", "parseResult", "Lch/njol/skript/lang/SkriptParser$ParseResult;", "([Lch/njol/skript/lang/Expression;ILch/njol/util/Kleenean;Lch/njol/skript/lang/SkriptParser$ParseResult;)Z", "check", "Companion", "SlimeLink"})
public final class CondSlimeWorldLoaded
extends Condition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Expression<String> worldName;

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        Expression<String> expression = this.worldName;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("worldName");
            expression = null;
        }
        return expression.toString(event, debug) + " " + (this.isNegated() ? "isn't" : "is") + " loaded";
    }

    public boolean init(@NotNull Expression<?>[] expressions, int matchedPattern, @Nullable Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        Intrinsics.checkNotNullParameter(expressions, "expressions");
        Intrinsics.checkNotNullParameter(parseResult, "parseResult");
        Expression<?> expression = expressions[0];
        Intrinsics.checkNotNull(expression, "null cannot be cast to non-null type ch.njol.skript.lang.Expression<kotlin.String>");
        this.worldName = expression;
        this.setNegated(parseResult.hasTag("1"));
        return true;
    }

    public boolean check(@Nullable Event event) {
        boolean isLoaded;
        if (event == null) {
            return false;
        }
        Expression<String> expression = this.worldName;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("worldName");
            expression = null;
        }
        String string = (String)expression.getSingle(event);
        if (string == null) {
            return false;
        }
        String worldNameValue = string;
        World bukkitWorld = Bukkit.getWorld((String)worldNameValue);
        boolean bl = isLoaded = bukkitWorld != null;
        return this.isNegated() ? !isLoaded : isLoaded;
    }

    static {
        String[] stringArray = new String[]{"(slimeworld|slime world) named %string% (is|1:is(n't| not)) loaded"};
        Skript.registerCondition(CondSlimeWorldLoaded.class, (String[])stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldev/danielmillar/slimelink/skript/conditions/CondSlimeWorldLoaded$Companion;", "", "<init>", "()V", "SlimeLink"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

